/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.jobs.mappers;

import java.util.Map;
import java.util.stream.Collectors;
import org.jobrunr.jobs.Job;
import org.slf4j.MDC;

public class MDCMapper {
    public static final String JOBRUNR_MDC_KEY = "mdc";

    public static void saveMDCContextToJob(Job job) {
        Map mdcContext = MDC.getCopyOfContextMap();
        if (mdcContext == null) {
            return;
        }
        mdcContext.forEach((key, value) -> job.getMetadata().put("mdc-" + key, value));
    }

    public static void loadMDCContextFromJob(Job job) {
        Map<String, Object> jobMetadata = job.getMetadata();
        Map<String, String> mdcContextMap = jobMetadata.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith("mdc-")).collect(Collectors.toMap(entry -> ((String)entry.getKey()).substring(4), entry -> entry.getValue().toString()));
        MDC.setContextMap(mdcContextMap);
    }
}

