/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.scheduling;

import java.time.Instant;
import java.time.ZoneId;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.jobrunr.configuration.JobRunr;
import org.jobrunr.jobs.Job;
import org.jobrunr.jobs.JobDetails;
import org.jobrunr.jobs.JobId;
import org.jobrunr.jobs.RecurringJob;
import org.jobrunr.jobs.filters.JobDefaultFilters;
import org.jobrunr.jobs.filters.JobFilter;
import org.jobrunr.jobs.filters.JobFilterUtils;
import org.jobrunr.jobs.mappers.MDCMapper;
import org.jobrunr.jobs.states.ScheduledState;
import org.jobrunr.scheduling.Schedule;
import org.jobrunr.storage.ConcurrentJobModificationException;
import org.jobrunr.storage.StorageProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractJobScheduler {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractJobScheduler.class);
    private final StorageProvider storageProvider;
    private final JobFilterUtils jobFilterUtils;

    public AbstractJobScheduler(StorageProvider storageProvider) {
        this(storageProvider, Collections.emptyList());
    }

    public AbstractJobScheduler(StorageProvider storageProvider, List<JobFilter> jobFilters) {
        if (storageProvider == null) {
            throw new IllegalArgumentException("A JobStorageProvider is required to use the JobScheduler. Please see the documentation on how to setup a JobStorageProvider.");
        }
        this.storageProvider = storageProvider;
        this.jobFilterUtils = new JobFilterUtils(new JobDefaultFilters(jobFilters));
    }

    public void delete(JobId jobId) {
        this.delete(jobId.asUUID());
    }

    public void delete(JobId jobId, String reason) {
        this.delete(jobId.asUUID(), reason);
    }

    public void delete(UUID id) {
        this.delete(id, "Deleted via JobScheduler API");
    }

    public void delete(UUID id, String reason) {
        Job jobToDelete = this.storageProvider.getJobById(id);
        jobToDelete.delete(reason);
        this.jobFilterUtils.runOnStateElectionFilter(jobToDelete);
        Job deletedJob = this.storageProvider.save(jobToDelete);
        this.jobFilterUtils.runOnStateAppliedFilters(deletedJob);
        LOGGER.debug("Deleted Job with id {}", (Object)deletedJob.getId());
    }

    public void delete(String id) {
        this.storageProvider.deleteRecurringJob(id);
    }

    public void shutdown() {
        JobRunr.destroy();
    }

    JobId enqueue(UUID id, JobDetails jobDetails) {
        return this.saveJob(new Job(id, jobDetails));
    }

    JobId schedule(UUID id, Instant scheduleAt, JobDetails jobDetails) {
        return this.saveJob(new Job(id, jobDetails, new ScheduledState(scheduleAt)));
    }

    String scheduleRecurrently(String id, JobDetails jobDetails, Schedule schedule, ZoneId zoneId) {
        RecurringJob recurringJob = new RecurringJob(id, jobDetails, schedule, zoneId);
        this.jobFilterUtils.runOnCreatingFilter(recurringJob);
        RecurringJob savedRecurringJob = this.storageProvider.saveRecurringJob(recurringJob);
        this.jobFilterUtils.runOnCreatedFilter(recurringJob);
        return savedRecurringJob.getId();
    }

    JobId saveJob(Job job) {
        try {
            MDCMapper.saveMDCContextToJob(job);
            this.jobFilterUtils.runOnCreatingFilter(job);
            Job savedJob = this.storageProvider.save(job);
            this.jobFilterUtils.runOnCreatedFilter(savedJob);
            LOGGER.debug("Created Job with id {}", (Object)job.getId());
        }
        catch (ConcurrentJobModificationException e) {
            LOGGER.info("Skipped Job with id {} as it already exists", (Object)job.getId());
        }
        return new JobId(job.getId());
    }

    List<Job> saveJobs(List<Job> jobs) {
        jobs.forEach(MDCMapper::saveMDCContextToJob);
        this.jobFilterUtils.runOnCreatingFilter(jobs);
        List<Job> savedJobs = this.storageProvider.save(jobs);
        this.jobFilterUtils.runOnCreatedFilter(savedJobs);
        return savedJobs;
    }
}

