/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.scheduling;

import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Stream;
import org.jobrunr.jobs.Job;
import org.jobrunr.jobs.JobDetails;
import org.jobrunr.jobs.JobId;
import org.jobrunr.jobs.filters.JobFilter;
import org.jobrunr.jobs.lambdas.JobRequest;
import org.jobrunr.scheduling.AbstractJobScheduler;
import org.jobrunr.scheduling.BackgroundJobRequest;
import org.jobrunr.scheduling.cron.CronExpression;
import org.jobrunr.scheduling.interval.Interval;
import org.jobrunr.storage.StorageProvider;
import org.jobrunr.utils.streams.StreamUtils;

public class JobRequestScheduler
extends AbstractJobScheduler {
    public JobRequestScheduler(StorageProvider storageProvider) {
        super(storageProvider, Collections.emptyList());
    }

    public JobRequestScheduler(StorageProvider storageProvider, List<JobFilter> jobFilters) {
        super(storageProvider, jobFilters);
        BackgroundJobRequest.setJobRequestScheduler(this);
    }

    public JobId enqueue(JobRequest jobRequest) {
        return this.enqueue(null, jobRequest);
    }

    public JobId enqueue(UUID id, JobRequest jobRequest) {
        JobDetails jobDetails = new JobDetails(jobRequest);
        return this.enqueue(id, jobDetails);
    }

    public void enqueue(Stream<? extends JobRequest> input) {
        input.map(JobDetails::new).map(Job::new).collect(StreamUtils.batchCollector(5000, this::saveJobs));
    }

    public JobId schedule(ZonedDateTime zonedDateTime, JobRequest jobRequest) {
        return this.schedule(null, zonedDateTime.toInstant(), jobRequest);
    }

    public JobId schedule(UUID id, ZonedDateTime zonedDateTime, JobRequest jobRequest) {
        return this.schedule(id, zonedDateTime.toInstant(), jobRequest);
    }

    public JobId schedule(OffsetDateTime offsetDateTime, JobRequest jobRequest) {
        return this.schedule(null, offsetDateTime.toInstant(), jobRequest);
    }

    public JobId schedule(UUID id, OffsetDateTime offsetDateTime, JobRequest jobRequest) {
        return this.schedule(id, offsetDateTime.toInstant(), jobRequest);
    }

    public JobId schedule(LocalDateTime localDateTime, JobRequest jobRequest) {
        return this.schedule(localDateTime.atZone(ZoneId.systemDefault()).toInstant(), jobRequest);
    }

    public JobId schedule(UUID id, LocalDateTime localDateTime, JobRequest jobRequest) {
        return this.schedule(id, localDateTime.atZone(ZoneId.systemDefault()).toInstant(), jobRequest);
    }

    public JobId schedule(Instant instant, JobRequest jobRequest) {
        return this.schedule(null, instant, jobRequest);
    }

    public JobId schedule(UUID id, Instant instant, JobRequest jobRequest) {
        JobDetails jobDetails = new JobDetails(jobRequest);
        return this.schedule(id, instant, jobDetails);
    }

    public String scheduleRecurrently(String cron, JobRequest jobRequest) {
        return this.scheduleRecurrently(null, cron, jobRequest);
    }

    public String scheduleRecurrently(String id, String cron, JobRequest jobRequest) {
        return this.scheduleRecurrently(id, cron, ZoneId.systemDefault(), jobRequest);
    }

    public String scheduleRecurrently(String id, String cron, ZoneId zoneId, JobRequest jobRequest) {
        JobDetails jobDetails = new JobDetails(jobRequest);
        return this.scheduleRecurrently(id, jobDetails, CronExpression.create(cron), zoneId);
    }

    public String scheduleRecurrently(Duration duration, JobRequest jobRequest) {
        return this.scheduleRecurrently(null, duration, jobRequest);
    }

    public String scheduleRecurrently(String id, Duration duration, JobRequest jobRequest) {
        JobDetails jobDetails = new JobDetails(jobRequest);
        return this.scheduleRecurrently(id, jobDetails, new Interval(duration), ZoneId.systemDefault());
    }
}

