/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.scheduling;

import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Stream;
import org.jobrunr.jobs.Job;
import org.jobrunr.jobs.JobDetails;
import org.jobrunr.jobs.JobId;
import org.jobrunr.jobs.details.JobDetailsAsmGenerator;
import org.jobrunr.jobs.details.JobDetailsGenerator;
import org.jobrunr.jobs.filters.JobFilter;
import org.jobrunr.jobs.lambdas.IocJobLambda;
import org.jobrunr.jobs.lambdas.IocJobLambdaFromStream;
import org.jobrunr.jobs.lambdas.JobLambda;
import org.jobrunr.jobs.lambdas.JobLambdaFromStream;
import org.jobrunr.scheduling.AbstractJobScheduler;
import org.jobrunr.scheduling.BackgroundJob;
import org.jobrunr.scheduling.cron.CronExpression;
import org.jobrunr.scheduling.interval.Interval;
import org.jobrunr.storage.StorageProvider;
import org.jobrunr.utils.streams.StreamUtils;

public class JobScheduler
extends AbstractJobScheduler {
    private final JobDetailsGenerator jobDetailsGenerator;

    public JobScheduler(StorageProvider storageProvider) {
        this(storageProvider, Collections.emptyList());
    }

    public JobScheduler(StorageProvider storageProvider, List<JobFilter> jobFilters) {
        this(storageProvider, new JobDetailsAsmGenerator(), jobFilters);
    }

    public JobScheduler(StorageProvider storageProvider, JobDetailsGenerator jobDetailsGenerator, List<JobFilter> jobFilters) {
        super(storageProvider, jobFilters);
        if (jobDetailsGenerator == null) {
            throw new IllegalArgumentException("A JobDetailsGenerator is required to use the JobScheduler.");
        }
        this.jobDetailsGenerator = jobDetailsGenerator;
        BackgroundJob.setJobScheduler(this);
    }

    public JobId enqueue(JobLambda job) {
        return this.enqueue(null, job);
    }

    public JobId enqueue(UUID id, JobLambda job) {
        JobDetails jobDetails = this.jobDetailsGenerator.toJobDetails(job);
        return this.enqueue(id, jobDetails);
    }

    public <T> void enqueue(Stream<T> input, JobLambdaFromStream<T> jobFromStream) {
        input.map(x -> this.jobDetailsGenerator.toJobDetails(x, jobFromStream)).map(Job::new).collect(StreamUtils.batchCollector(5000, this::saveJobs));
    }

    public <S> JobId enqueue(IocJobLambda<S> iocJob) {
        return this.enqueue(null, iocJob);
    }

    public <S> JobId enqueue(UUID id, IocJobLambda<S> iocJob) {
        JobDetails jobDetails = this.jobDetailsGenerator.toJobDetails(iocJob);
        return this.enqueue(id, jobDetails);
    }

    public <S, T> void enqueue(Stream<T> input, IocJobLambdaFromStream<S, T> iocJobFromStream) {
        input.map(x -> this.jobDetailsGenerator.toJobDetails(x, iocJobFromStream)).map(Job::new).collect(StreamUtils.batchCollector(5000, this::saveJobs));
    }

    public JobId schedule(ZonedDateTime zonedDateTime, JobLambda job) {
        return this.schedule(null, zonedDateTime.toInstant(), job);
    }

    public JobId schedule(UUID id, ZonedDateTime zonedDateTime, JobLambda job) {
        return this.schedule(id, zonedDateTime.toInstant(), job);
    }

    public <S> JobId schedule(ZonedDateTime zonedDateTime, IocJobLambda<S> iocJob) {
        return this.schedule(null, zonedDateTime.toInstant(), iocJob);
    }

    public <S> JobId schedule(UUID id, ZonedDateTime zonedDateTime, IocJobLambda<S> iocJob) {
        return this.schedule(id, zonedDateTime.toInstant(), iocJob);
    }

    public JobId schedule(OffsetDateTime offsetDateTime, JobLambda job) {
        return this.schedule(null, offsetDateTime.toInstant(), job);
    }

    public JobId schedule(UUID id, OffsetDateTime offsetDateTime, JobLambda job) {
        return this.schedule(id, offsetDateTime.toInstant(), job);
    }

    public <S> JobId schedule(OffsetDateTime offsetDateTime, IocJobLambda<S> iocJob) {
        return this.schedule(null, offsetDateTime.toInstant(), iocJob);
    }

    public <S> JobId schedule(UUID id, OffsetDateTime offsetDateTime, IocJobLambda<S> iocJob) {
        return this.schedule(id, offsetDateTime.toInstant(), iocJob);
    }

    public JobId schedule(LocalDateTime localDateTime, JobLambda job) {
        return this.schedule(localDateTime.atZone(ZoneId.systemDefault()).toInstant(), job);
    }

    public JobId schedule(UUID id, LocalDateTime localDateTime, JobLambda job) {
        return this.schedule(id, localDateTime.atZone(ZoneId.systemDefault()).toInstant(), job);
    }

    public <S> JobId schedule(LocalDateTime localDateTime, IocJobLambda<S> iocJob) {
        return this.schedule(localDateTime.atZone(ZoneId.systemDefault()).toInstant(), iocJob);
    }

    public <S> JobId schedule(UUID id, LocalDateTime localDateTime, IocJobLambda<S> iocJob) {
        return this.schedule(id, localDateTime.atZone(ZoneId.systemDefault()).toInstant(), iocJob);
    }

    public JobId schedule(Instant instant, JobLambda job) {
        return this.schedule(null, instant, job);
    }

    public JobId schedule(UUID id, Instant instant, JobLambda job) {
        JobDetails jobDetails = this.jobDetailsGenerator.toJobDetails(job);
        return this.schedule(id, instant, jobDetails);
    }

    public <S> JobId schedule(Instant instant, IocJobLambda<S> iocJob) {
        return this.schedule(null, instant, iocJob);
    }

    public <S> JobId schedule(UUID id, Instant instant, IocJobLambda<S> iocJob) {
        JobDetails jobDetails = this.jobDetailsGenerator.toJobDetails(iocJob);
        return this.schedule(id, instant, jobDetails);
    }

    public String scheduleRecurrently(String cron, JobLambda job) {
        return this.scheduleRecurrently(null, cron, job);
    }

    public <S> String scheduleRecurrently(String cron, IocJobLambda<S> iocJob) {
        return this.scheduleRecurrently(null, cron, iocJob);
    }

    public String scheduleRecurrently(String id, String cron, JobLambda job) {
        return this.scheduleRecurrently(id, cron, ZoneId.systemDefault(), job);
    }

    public <S> String scheduleRecurrently(String id, String cron, IocJobLambda<S> iocJob) {
        return this.scheduleRecurrently(id, cron, ZoneId.systemDefault(), iocJob);
    }

    public String scheduleRecurrently(String id, String cron, ZoneId zoneId, JobLambda job) {
        JobDetails jobDetails = this.jobDetailsGenerator.toJobDetails(job);
        return this.scheduleRecurrently(id, jobDetails, CronExpression.create(cron), zoneId);
    }

    public <S> String scheduleRecurrently(String id, String cron, ZoneId zoneId, IocJobLambda<S> iocJob) {
        JobDetails jobDetails = this.jobDetailsGenerator.toJobDetails(iocJob);
        return this.scheduleRecurrently(id, jobDetails, CronExpression.create(cron), zoneId);
    }

    public String scheduleRecurrently(Duration duration, JobLambda job) {
        return this.scheduleRecurrently(null, duration, job);
    }

    public <S> String scheduleRecurrently(Duration duration, IocJobLambda<S> iocJob) {
        return this.scheduleRecurrently(null, duration, iocJob);
    }

    public String scheduleRecurrently(String id, Duration duration, JobLambda job) {
        JobDetails jobDetails = this.jobDetailsGenerator.toJobDetails(job);
        return this.scheduleRecurrently(id, jobDetails, new Interval(duration), ZoneId.systemDefault());
    }

    public <S> String scheduleRecurrently(String id, Duration duration, IocJobLambda<S> iocJob) {
        JobDetails jobDetails = this.jobDetailsGenerator.toJobDetails(iocJob);
        return this.scheduleRecurrently(id, jobDetails, new Interval(duration), ZoneId.systemDefault());
    }
}

