/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.scheduling.cron;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Month;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.BitSet;
import java.util.Calendar;
import org.jobrunr.scheduling.Schedule;
import org.jobrunr.scheduling.cron.CronFieldParser;
import org.jobrunr.scheduling.cron.CronFieldType;
import org.jobrunr.scheduling.cron.InvalidCronExpressionException;

public class CronExpression
extends Schedule {
    private static final CronFieldParser SECONDS_FIELD_PARSER = new CronFieldParser(CronFieldType.SECOND);
    private static final CronFieldParser MINUTES_FIELD_PARSER = new CronFieldParser(CronFieldType.MINUTE);
    private static final CronFieldParser HOURS_FIELD_PARSER = new CronFieldParser(CronFieldType.HOUR);
    private static final CronFieldParser DAYS_FIELD_PARSER = new CronFieldParser(CronFieldType.DAY);
    private static final CronFieldParser MONTHS_FIELD_PARSER = new CronFieldParser(CronFieldType.MONTH);
    private static final CronFieldParser DAY_OF_WEEK_FIELD_PARSER = new CronFieldParser(CronFieldType.DAY_OF_WEEK);
    private String expression;
    private boolean hasSecondsField;
    private DaysAndDaysOfWeekRelation daysAndDaysOfWeekRelation;
    private BitSet seconds;
    private BitSet minutes;
    private BitSet hours;
    private BitSet days;
    private BitSet months;
    private BitSet daysOfWeek;
    private BitSet daysOf5Weeks;
    private boolean isLastDayOfMonth;
    private boolean isSpecificLastDayOfMonth;

    private CronExpression() {
    }

    public static CronExpression create(String expression) {
        String token;
        if (expression.isEmpty()) {
            throw new InvalidCronExpressionException("empty expression");
        }
        String[] fields = expression.trim().toLowerCase().split("\\s+");
        int count = fields.length;
        if (count > 6 || count < 5) {
            throw new InvalidCronExpressionException("crontab expression should have 6 fields for (seconds resolution) or 5 fields for (minutes resolution)");
        }
        CronExpression cronExpression = new CronExpression();
        cronExpression.hasSecondsField = count == 6;
        int index = 0;
        if (cronExpression.hasSecondsField) {
            token = fields[index++];
            cronExpression.seconds = SECONDS_FIELD_PARSER.parse(token);
        } else {
            cronExpression.seconds = new BitSet(1);
            cronExpression.seconds.set(0);
        }
        token = fields[index++];
        cronExpression.minutes = MINUTES_FIELD_PARSER.parse(token);
        token = fields[index++];
        cronExpression.hours = HOURS_FIELD_PARSER.parse(token);
        String daysToken = token = fields[index++];
        cronExpression.days = DAYS_FIELD_PARSER.parse(token);
        cronExpression.isLastDayOfMonth = token.equals("l");
        boolean daysStartWithAsterisk = token.startsWith("*");
        token = fields[index++];
        cronExpression.months = MONTHS_FIELD_PARSER.parse(token);
        token = fields[index++];
        cronExpression.daysOfWeek = DAY_OF_WEEK_FIELD_PARSER.parse(token);
        boolean daysOfWeekStartAsterisk = token.startsWith("*");
        if (token.length() == 2 && token.endsWith("l")) {
            if (cronExpression.isLastDayOfMonth) {
                throw new InvalidCronExpressionException("You can only specify the last day of month week in either the DAY field or in the DAY_OF_WEEK field, not both.");
            }
            if (!daysToken.equalsIgnoreCase("*")) {
                throw new InvalidCronExpressionException("when last days of month is specified. the day of the month must be \"*\"");
            }
            cronExpression.isSpecificLastDayOfMonth = true;
        }
        cronExpression.daysOf5Weeks = CronExpression.generateDaysOf5Weeks(cronExpression.daysOfWeek);
        DaysAndDaysOfWeekRelation daysAndDaysOfWeekRelation = cronExpression.daysAndDaysOfWeekRelation = daysStartWithAsterisk || daysOfWeekStartAsterisk ? DaysAndDaysOfWeekRelation.INTERSECT : DaysAndDaysOfWeekRelation.UNION;
        if (!cronExpression.canScheduleActuallyOccur()) {
            throw new InvalidCronExpressionException("Cron expression not valid. The specified months do not have the day 30th or the day 31st");
        }
        cronExpression.expression = expression.trim();
        return cronExpression;
    }

    @Override
    public Instant next(Instant createdAtInstant, Instant currentInstant, ZoneId zoneId) {
        int candidateDay;
        LocalDateTime baseDate = LocalDateTime.ofInstant(currentInstant, zoneId);
        int baseSecond = baseDate.getSecond();
        int baseMinute = baseDate.getMinute();
        int baseHour = baseDate.getHour();
        int baseDay = baseDate.getDayOfMonth();
        int baseMonth = baseDate.getMonthValue();
        int baseYear = baseDate.getYear();
        int second = baseSecond;
        int minute = baseMinute;
        int hour = baseHour;
        int day = baseDay;
        int month = baseMonth;
        int year = baseYear;
        if (this.hasSecondsField) {
            ++second;
            if ((second = this.seconds.nextSetBit(second)) < 0) {
                second = this.seconds.nextSetBit(0);
                ++minute;
            }
        } else {
            ++minute;
        }
        if ((minute = this.minutes.nextSetBit(minute)) < 0) {
            ++hour;
            second = this.seconds.nextSetBit(0);
            minute = this.minutes.nextSetBit(0);
        } else if (minute > baseMinute) {
            second = this.seconds.nextSetBit(0);
        }
        hour = this.hours.nextSetBit(hour);
        if (hour < 0) {
            ++day;
            second = this.seconds.nextSetBit(0);
            minute = this.minutes.nextSetBit(0);
            hour = this.hours.nextSetBit(0);
        } else if (hour > baseHour) {
            second = this.seconds.nextSetBit(0);
            minute = this.minutes.nextSetBit(0);
        }
        while (true) {
            int candidateMonth;
            if ((candidateMonth = this.months.nextSetBit(month)) < 0) {
                ++year;
                second = this.seconds.nextSetBit(0);
                minute = this.minutes.nextSetBit(0);
                hour = this.hours.nextSetBit(0);
                day = 1;
                candidateMonth = this.months.nextSetBit(0);
            } else if (candidateMonth > month) {
                second = this.seconds.nextSetBit(0);
                minute = this.minutes.nextSetBit(0);
                hour = this.hours.nextSetBit(0);
                day = 1;
            }
            month = candidateMonth;
            BitSet adjustedDaysSet = this.getUpdatedDays(year, month);
            candidateDay = adjustedDaysSet.nextSetBit(day - 1) + 1;
            if (candidateDay >= 1) break;
            ++month;
            second = this.seconds.nextSetBit(0);
            minute = this.minutes.nextSetBit(0);
            hour = this.hours.nextSetBit(0);
            day = 1;
        }
        if (candidateDay > day) {
            second = this.seconds.nextSetBit(0);
            minute = this.minutes.nextSetBit(0);
            hour = this.hours.nextSetBit(0);
        }
        day = candidateDay;
        return LocalDateTime.of(year, month, day, hour, minute, second).atZone(zoneId).toInstant();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof CronExpression)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        CronExpression cronExpression = (CronExpression)obj;
        return this.seconds.equals(cronExpression.seconds) && this.minutes.equals(cronExpression.minutes) && this.hours.equals(cronExpression.hours) && this.days.equals(cronExpression.days) && this.months.equals(cronExpression.months) && this.daysOfWeek.equals(cronExpression.daysOfWeek);
    }

    @Override
    public int hashCode() {
        int result = this.seconds.hashCode();
        result = 31 * result + this.minutes.hashCode();
        result = 31 * result + this.hours.hashCode();
        result = 31 * result + this.days.hashCode();
        result = 31 * result + this.months.hashCode();
        result = 31 * result + this.daysOfWeek.hashCode();
        return result;
    }

    public static boolean isLeapYear(int year) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        return cal.getActualMaximum(6) > 365;
    }

    public int getNumberOfFields() {
        return this.hasSecondsField ? 6 : 5;
    }

    public String getExpression() {
        return this.expression;
    }

    private boolean canScheduleActuallyOccur() {
        if (this.daysAndDaysOfWeekRelation == DaysAndDaysOfWeekRelation.UNION || this.days.nextSetBit(0) < 29) {
            return true;
        }
        int aYear = LocalDateTime.now().getYear();
        for (int dayIndex = 29; dayIndex < 31; ++dayIndex) {
            if (!this.days.get(dayIndex)) continue;
            for (int monthIndex = 0; monthIndex <= 12; ++monthIndex) {
                if (!this.months.get(monthIndex) || dayIndex + 1 > YearMonth.of(aYear, monthIndex).lengthOfMonth()) continue;
                return true;
            }
        }
        return false;
    }

    private static BitSet generateDaysOf5Weeks(BitSet daysOfWeek) {
        int weekLength = 7;
        int setLength = weekLength + 31;
        BitSet bitSet = new BitSet(setLength);
        for (int i = 0; i < setLength; i += weekLength) {
            for (int j = 0; j < weekLength; ++j) {
                bitSet.set(j + i, daysOfWeek.get(j));
            }
        }
        return bitSet;
    }

    private BitSet getUpdatedDays(int year, int month) {
        BitSet updatedDays;
        block9: {
            int j;
            int dayCountInMonth;
            block8: {
                LocalDate date = LocalDate.of(year, month, 1);
                int daysOf5WeeksOffset = date.getDayOfWeek().getValue();
                updatedDays = new BitSet(31);
                updatedDays.or(this.days);
                BitSet monthDaysOfWeeks = this.daysOf5Weeks.get(daysOf5WeeksOffset, daysOf5WeeksOffset + 31);
                if (this.isSpecificLastDayOfMonth || this.daysAndDaysOfWeekRelation == DaysAndDaysOfWeekRelation.INTERSECT) {
                    updatedDays.and(monthDaysOfWeeks);
                } else {
                    updatedDays.or(monthDaysOfWeeks);
                }
                if (month == Month.FEBRUARY.getValue()) {
                    dayCountInMonth = 28;
                    if (CronExpression.isLeapYear(year)) {
                        ++dayCountInMonth;
                    }
                } else {
                    dayCountInMonth = YearMonth.of(year, month).lengthOfMonth();
                }
                for (j = dayCountInMonth; j < 31; ++j) {
                    updatedDays.set(j, false);
                }
                if (!this.isLastDayOfMonth) break block8;
                for (j = 0; j < dayCountInMonth; ++j) {
                    updatedDays.set(j, j + 1 == dayCountInMonth);
                }
                break block9;
            }
            if (!this.isSpecificLastDayOfMonth) break block9;
            for (j = 0; j < dayCountInMonth - 7; ++j) {
                updatedDays.set(j, false);
            }
        }
        return updatedDays;
    }

    @Override
    public void validateSchedule() {
        Instant base = Instant.EPOCH;
        Instant fiveSeconds = base.plusSeconds(5L);
        if (this.next(base, base, ZoneOffset.UTC).isBefore(fiveSeconds)) {
            throw new IllegalArgumentException(String.format("The smallest interval for recurring jobs is %d seconds. Please also make sure that your 'pollIntervalInSeconds' configuration matches the smallest recurring job interval.", 5));
        }
    }

    public String toString() {
        return this.expression;
    }

    private static enum DaysAndDaysOfWeekRelation {
        INTERSECT,
        UNION;

    }
}

