/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.server.concurrent;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.jobrunr.jobs.Job;
import org.jobrunr.server.JobZooKeeper;
import org.jobrunr.server.concurrent.ConcurrentJobModificationResolveResult;
import org.jobrunr.server.concurrent.ConcurrentJobModificationResolver;
import org.jobrunr.server.concurrent.UnresolvableConcurrentJobModificationException;
import org.jobrunr.server.concurrent.statechanges.AllowedConcurrentStateChange;
import org.jobrunr.server.concurrent.statechanges.DeletedWhileEnqueuedConcurrentStateChange;
import org.jobrunr.server.concurrent.statechanges.DeletedWhileFailedConcurrentStateChange;
import org.jobrunr.server.concurrent.statechanges.DeletedWhileProcessingConcurrentStateChange;
import org.jobrunr.server.concurrent.statechanges.DeletedWhileScheduledConcurrentStateChange;
import org.jobrunr.server.concurrent.statechanges.DeletedWhileSucceededConcurrentStateChange;
import org.jobrunr.server.concurrent.statechanges.PermanentlyDeletedWhileProcessingConcurrentStateChange;
import org.jobrunr.storage.ConcurrentJobModificationException;
import org.jobrunr.storage.JobNotFoundException;
import org.jobrunr.storage.StorageProvider;

public class DefaultConcurrentJobModificationResolver
implements ConcurrentJobModificationResolver {
    private final StorageProvider storageProvider;
    private final List<AllowedConcurrentStateChange> allowedConcurrentStateChanges;

    public DefaultConcurrentJobModificationResolver(StorageProvider storageProvider, JobZooKeeper jobZooKeeper) {
        this.storageProvider = storageProvider;
        this.allowedConcurrentStateChanges = Arrays.asList(new PermanentlyDeletedWhileProcessingConcurrentStateChange(jobZooKeeper), new DeletedWhileProcessingConcurrentStateChange(jobZooKeeper), new DeletedWhileSucceededConcurrentStateChange(), new DeletedWhileFailedConcurrentStateChange(), new DeletedWhileEnqueuedConcurrentStateChange(), new DeletedWhileScheduledConcurrentStateChange());
    }

    @Override
    public void resolve(ConcurrentJobModificationException e) {
        List<Job> concurrentUpdatedJobs = e.getConcurrentUpdatedJobs();
        List<ConcurrentJobModificationResolveResult> failedToResolve = concurrentUpdatedJobs.stream().map(this::resolve).filter(ConcurrentJobModificationResolveResult::failed).collect(Collectors.toList());
        if (!failedToResolve.isEmpty()) {
            throw new UnresolvableConcurrentJobModificationException(failedToResolve);
        }
    }

    public ConcurrentJobModificationResolveResult resolve(Job localJob) {
        Job jobFromStorage = this.getJobFromStorageProvider(localJob);
        return this.allowedConcurrentStateChanges.stream().filter(allowedConcurrentStateChange -> allowedConcurrentStateChange.matches(localJob, jobFromStorage)).findFirst().map(allowedConcurrentStateChange -> allowedConcurrentStateChange.resolve(localJob, jobFromStorage)).orElse(ConcurrentJobModificationResolveResult.failed(localJob, jobFromStorage));
    }

    private Job getJobFromStorageProvider(Job localJob) {
        try {
            return this.storageProvider.getJobById(localJob.getId());
        }
        catch (JobNotFoundException e) {
            return null;
        }
    }
}

