/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.server.dashboard;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.jobrunr.server.dashboard.DashboardNotification;
import org.jobrunr.server.dashboard.mappers.CpuAllocationIrregularityNotificationMapper;
import org.jobrunr.server.dashboard.mappers.DashboardNotificationMapper;
import org.jobrunr.server.dashboard.mappers.NewJobRunrVersionNotificationMapper;
import org.jobrunr.server.dashboard.mappers.SevereJobRunrExceptionNotificationMapper;
import org.jobrunr.storage.StorageProvider;
import org.jobrunr.utils.reflection.ReflectionUtils;

public class DashboardNotificationManager {
    private final StorageProvider storageProvider;
    private final Set<DashboardNotificationMapper<?>> notificationMappers;

    public DashboardNotificationManager(UUID backgroundJobServerId, StorageProvider storageProvider) {
        this.storageProvider = storageProvider;
        this.notificationMappers = new HashSet<DashboardNotificationMapper>(Arrays.asList(new SevereJobRunrExceptionNotificationMapper(backgroundJobServerId, storageProvider), new CpuAllocationIrregularityNotificationMapper(backgroundJobServerId), new NewJobRunrVersionNotificationMapper()));
    }

    public void handle(Exception e) {
        if (e instanceof DashboardNotification) {
            this.notify((DashboardNotification)((Object)e));
        }
    }

    public void notify(DashboardNotification e) {
        this.notificationMappers.stream().filter(notificationMapper -> notificationMapper.supports(e)).map(notificationMapper -> notificationMapper.map(e)).forEach(this.storageProvider::saveMetadata);
    }

    public void deleteNotification(Class<? extends DashboardNotification> notificationToDelete) {
        this.storageProvider.deleteMetadata(notificationToDelete.getSimpleName());
    }

    public <T extends DashboardNotification> T getDashboardNotification(Class<T> notificationClass) {
        return (T)((DashboardNotification)this.storageProvider.getMetadata(notificationClass.getSimpleName()).stream().map(metadata -> (DashboardNotification)ReflectionUtils.newInstance(notificationClass, metadata)).findFirst().orElse(null));
    }
}

