/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.server.dashboard.mappers;

import java.time.Instant;
import java.util.UUID;
import org.jobrunr.SevereJobRunrException;
import org.jobrunr.configuration.JobRunr;
import org.jobrunr.server.dashboard.DashboardNotification;
import org.jobrunr.server.dashboard.mappers.DashboardNotificationMapper;
import org.jobrunr.storage.JobRunrMetadata;
import org.jobrunr.storage.StorageProvider;
import org.jobrunr.storage.ThreadSafeStorageProvider;
import org.jobrunr.utils.RuntimeUtils;
import org.jobrunr.utils.StringUtils;
import org.jobrunr.utils.diagnostics.DiagnosticsBuilder;
import org.jobrunr.utils.metadata.VersionRetriever;

public class SevereJobRunrExceptionNotificationMapper
implements DashboardNotificationMapper<SevereJobRunrException> {
    private final String id;
    private final StorageProvider storageProvider;

    public SevereJobRunrExceptionNotificationMapper(UUID backgroundJobServerId, StorageProvider storageProvider) {
        this.id = "BackgroundJobServer " + backgroundJobServerId;
        this.storageProvider = storageProvider;
    }

    @Override
    public boolean supports(DashboardNotification exception) {
        return exception instanceof SevereJobRunrException;
    }

    @Override
    public JobRunrMetadata mapToMetadata(SevereJobRunrException notification) {
        String diagnosticsInfo = DiagnosticsBuilder.diagnostics().withTitle(notification.getClass().getSimpleName() + " occurred in " + this.id + (StringUtils.isNotNullOrEmpty(notification.getMessage()) ? ": " + notification.getMessage() : "")).withEmptyLine().withSubTitle("Runtime information").withBulletedLine("Timestamp", Instant.now().toString()).withBulletedLine("Location", this.id).withBulletedLine("JobRunr Version", VersionRetriever.getVersion(JobRunr.class)).withBulletedLine("StorageProvider", this.storageProvider instanceof ThreadSafeStorageProvider ? ((ThreadSafeStorageProvider)this.storageProvider).getStorageProvider().getClass().getName() : this.storageProvider.getClass().getName()).withBulletedLine("Java Version", System.getProperty("java.version")).withBulletedLine("Is running from nested jar", Boolean.toString(RuntimeUtils.isRunningFromNestedJar())).withEmptyLine().withSubTitle("Background Job Servers").with(this.storageProvider.getBackgroundJobServers(), (server, diagnosticsBuilder) -> diagnosticsBuilder.withBulletedLine(String.format("BackgroundJobServer id: %s\n(workerPoolSize: %d, pollIntervalInSeconds: %d, firstHeartbeat: %s, lastHeartbeat: %s)", server.getId(), server.getWorkerPoolSize(), server.getPollIntervalInSeconds(), server.getFirstHeartbeat(), server.getLastHeartbeat()))).withEmptyLine().withSubTitle("Diagnostics from exception").withDiagnostics(2, notification.getDiagnostics()).withEmptyLine().withSubTitle("Exception").withException(notification).asMarkDown();
        return new JobRunrMetadata(SevereJobRunrException.class.getSimpleName(), this.id, diagnosticsInfo);
    }
}

