/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.server.tasks;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jobrunr.configuration.JobRunr;
import org.jobrunr.server.BackgroundJobServer;
import org.jobrunr.server.dashboard.DashboardNotificationManager;
import org.jobrunr.server.dashboard.NewJobRunrVersionNotification;
import org.jobrunr.utils.StringUtils;
import org.jobrunr.utils.annotations.VisibleFor;
import org.jobrunr.utils.metadata.VersionRetriever;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckForNewJobRunrVersion
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(CheckForNewJobRunrVersion.class);
    private static final Pattern versionPattern = Pattern.compile("\"latestVersion\"\\s*:\\s*\"(.*)\"");
    private final DashboardNotificationManager dashboardNotificationManager;
    private static boolean isFirstRun;

    public CheckForNewJobRunrVersion(BackgroundJobServer backgroundJobServer) {
        this.dashboardNotificationManager = backgroundJobServer.getDashboardNotificationManager();
        isFirstRun = true;
    }

    @Override
    public void run() {
        if (isFirstRun) {
            VersionNumber latestVersion;
            VersionNumber actualVersion;
            NewJobRunrVersionNotification newJobRunrVersionNotification = this.dashboardNotificationManager.getDashboardNotification(NewJobRunrVersionNotification.class);
            if (newJobRunrVersionNotification != null && (actualVersion = new VersionNumber(CheckForNewJobRunrVersion.getActualVersion())).equals(latestVersion = new VersionNumber(newJobRunrVersionNotification.getLatestVersion()))) {
                this.dashboardNotificationManager.deleteNotification(NewJobRunrVersionNotification.class);
            }
        } else {
            try {
                VersionNumber latestVersion = new VersionNumber(CheckForNewJobRunrVersion.getLatestVersion());
                VersionNumber actualVersion = new VersionNumber(CheckForNewJobRunrVersion.getActualVersion());
                if (latestVersion.compareTo(actualVersion) > 0) {
                    this.dashboardNotificationManager.notify(new NewJobRunrVersionNotification(latestVersion.getCompleteVersion()));
                    LOGGER.info("JobRunr version {} is available.", (Object)latestVersion.completeVersion);
                } else {
                    this.dashboardNotificationManager.deleteNotification(NewJobRunrVersionNotification.class);
                }
            }
            catch (IOException e) {
                LOGGER.info("Unable to check for new JobRunr version:\n {}", (Object)e.getMessage());
            }
        }
        isFirstRun = false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @VisibleFor(value="testing")
    static String getLatestVersion() throws IOException {
        URL apiUrl = new URL(CheckForNewJobRunrVersion.getJobRunrVersionUrl());
        HttpURLConnection con = (HttpURLConnection)apiUrl.openConnection();
        con.setRequestProperty("User-Agent", "JobRunr " + CheckForNewJobRunrVersion.getActualVersion());
        con.setRequestMethod("GET");
        con.setConnectTimeout(2000);
        con.setReadTimeout(2000);
        try (BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));){
            String inputLine;
            StringBuilder content = new StringBuilder();
            while ((inputLine = in.readLine()) != null) {
                content.append(inputLine);
            }
            Matcher matcher = versionPattern.matcher(content);
            boolean versionIsFound = matcher.find();
            if (!versionIsFound) throw new IOException("JobRunr API has changed?");
            String string = matcher.group(1).replace("v", "");
            return string;
        }
        catch (UnknownHostException e) {
            throw e;
        }
        catch (IOException e) {
            BufferedReader in2 = new BufferedReader(new InputStreamReader(con.getErrorStream()));
            try {
                String inputLine;
                StringBuilder content = new StringBuilder();
                while ((inputLine = in2.readLine()) != null) {
                    content.append(inputLine);
                }
                throw new IOException(content.toString());
            }
            catch (Throwable throwable) {
                try {
                    in2.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    @VisibleFor(value="testing")
    static String getJobRunrVersionUrl() {
        return "https://api.jobrunr.io/api/version/jobrunr/latest";
    }

    @VisibleFor(value="testing")
    static String getActualVersion() {
        return VersionRetriever.getVersion(JobRunr.class);
    }

    static void resetCheckForNewVersion() {
        isFirstRun = true;
    }

    protected static class VersionNumber
    implements Comparable<VersionNumber> {
        private final String completeVersion;
        private final String version;
        private final String qualifier;

        public VersionNumber(String completeVersion) {
            this.completeVersion = completeVersion;
            this.version = StringUtils.substringBefore(completeVersion, "-");
            this.qualifier = StringUtils.substringAfter(completeVersion, "-");
        }

        public String getCompleteVersion() {
            return this.completeVersion;
        }

        public boolean equals(Object obj) {
            if (obj instanceof VersionNumber) {
                return this.completeVersion.equals(((VersionNumber)obj).completeVersion);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode(this.completeVersion);
        }

        @Override
        public int compareTo(VersionNumber o) {
            int versionsCompared = this.version.compareTo(o.version);
            if (versionsCompared == 0) {
                if (StringUtils.isNullOrEmpty(this.qualifier) && StringUtils.isNullOrEmpty(o.qualifier)) {
                    return 0;
                }
                if (StringUtils.isNullOrEmpty(this.qualifier) && StringUtils.isNotNullOrEmpty(o.qualifier)) {
                    return 1;
                }
                if (StringUtils.isNotNullOrEmpty(this.qualifier) && StringUtils.isNullOrEmpty(o.qualifier)) {
                    return -1;
                }
                return this.qualifier.compareTo(o.qualifier);
            }
            return versionsCompared;
        }
    }
}

