/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.storage;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.jobrunr.jobs.Job;
import org.jobrunr.jobs.JobId;
import org.jobrunr.storage.BackgroundJobServerStatus;
import org.jobrunr.storage.JobNotFoundException;
import org.jobrunr.storage.JobRunrMetadata;
import org.jobrunr.storage.JobStatsEnricher;
import org.jobrunr.storage.JobStatsExtended;
import org.jobrunr.storage.StorageProvider;
import org.jobrunr.storage.listeners.BackgroundJobServerStatusChangeListener;
import org.jobrunr.storage.listeners.JobChangeListener;
import org.jobrunr.storage.listeners.JobStatsChangeListener;
import org.jobrunr.storage.listeners.MetadataChangeListener;
import org.jobrunr.storage.listeners.StorageProviderChangeListener;
import org.jobrunr.utils.resilience.RateLimiter;
import org.jobrunr.utils.streams.StreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStorageProvider
implements StorageProvider,
AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractStorageProvider.class);
    private final Set<StorageProviderChangeListener> onChangeListeners = ConcurrentHashMap.newKeySet();
    private final JobStatsEnricher jobStatsEnricher = new JobStatsEnricher();
    private final RateLimiter changeListenerNotificationRateLimit;
    private final ReentrantLock reentrantLock;
    private volatile Timer timer;

    protected AbstractStorageProvider(RateLimiter changeListenerNotificationRateLimit) {
        this.changeListenerNotificationRateLimit = changeListenerNotificationRateLimit;
        this.reentrantLock = new ReentrantLock();
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void addJobStorageOnChangeListener(StorageProviderChangeListener listener) {
        this.onChangeListeners.add(listener);
        this.startTimerToSendUpdates();
    }

    @Override
    public void removeJobStorageOnChangeListener(StorageProviderChangeListener listener) {
        this.onChangeListeners.remove(listener);
        if (this.onChangeListeners.isEmpty()) {
            this.stopTimerToSendUpdates();
        }
    }

    @Override
    public void close() {
        this.stopTimerToSendUpdates();
    }

    protected void notifyJobStatsOnChangeListenersIf(boolean mustNotify) {
        if (mustNotify) {
            this.notifyJobStatsOnChangeListeners();
        }
    }

    protected void notifyJobStatsOnChangeListeners() {
        try {
            if (this.changeListenerNotificationRateLimit.isRateLimited()) {
                return;
            }
            List<JobStatsChangeListener> jobStatsChangeListeners = StreamUtils.ofType(this.onChangeListeners, JobStatsChangeListener.class).collect(Collectors.toList());
            if (!jobStatsChangeListeners.isEmpty()) {
                JobStatsExtended extendedJobStats = this.jobStatsEnricher.enrich(this.getJobStats());
                jobStatsChangeListeners.forEach(listener -> listener.onChange(extendedJobStats));
            }
        }
        catch (Exception e) {
            this.logError(e);
        }
    }

    protected void notifyMetadataChangeListeners(boolean mustNotify) {
        if (mustNotify) {
            this.notifyMetadataChangeListeners();
        }
    }

    protected void notifyMetadataChangeListeners() {
        try {
            Map<String, List<MetadataChangeListener>> metadataChangeListenersByName = StreamUtils.ofType(this.onChangeListeners, MetadataChangeListener.class).collect(Collectors.groupingBy(MetadataChangeListener::listenForChangesOfMetadataName));
            if (!metadataChangeListenersByName.isEmpty()) {
                metadataChangeListenersByName.forEach((metadataName, listeners) -> {
                    List<JobRunrMetadata> jobRunrMetadata = this.getMetadata((String)metadataName);
                    listeners.forEach(listener -> listener.onChange(jobRunrMetadata));
                });
            }
        }
        catch (Exception e) {
            this.logError(e);
        }
    }

    private void notifyJobChangeListeners() {
        try {
            Map<JobId, List<JobChangeListener>> listenerByJob = StreamUtils.ofType(this.onChangeListeners, JobChangeListener.class).collect(Collectors.groupingBy(JobChangeListener::getJobId));
            if (!listenerByJob.isEmpty()) {
                listenerByJob.forEach((jobId, listeners) -> {
                    try {
                        Job job = this.getJobById((JobId)jobId);
                        listeners.forEach(listener -> listener.onChange(job));
                    }
                    catch (JobNotFoundException jobNotFoundException) {
                        listeners.forEach(jobChangeListener -> {
                            try {
                                jobChangeListener.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        });
                    }
                });
            }
        }
        catch (Exception e) {
            this.logError(e);
        }
    }

    private void notifyBackgroundJobServerStatusChangeListeners() {
        try {
            List<BackgroundJobServerStatusChangeListener> serverChangeListeners = StreamUtils.ofType(this.onChangeListeners, BackgroundJobServerStatusChangeListener.class).collect(Collectors.toList());
            if (!serverChangeListeners.isEmpty()) {
                List<BackgroundJobServerStatus> servers = this.getBackgroundJobServers();
                serverChangeListeners.forEach(listener -> listener.onChange(servers));
            }
        }
        catch (Exception e) {
            this.logError(e);
        }
    }

    void startTimerToSendUpdates() {
        if (this.timer == null) {
            try {
                if (this.reentrantLock.tryLock()) {
                    this.timer = new Timer(true);
                    this.timer.schedule((TimerTask)new NotifyOnChangeListeners(), 3000L, 5000L);
                }
            }
            finally {
                this.reentrantLock.unlock();
            }
        }
    }

    void stopTimerToSendUpdates() {
        if (this.timer != null) {
            boolean canCancelTimer;
            boolean bl = canCancelTimer = this.timer != null && this.reentrantLock.tryLock();
            if (canCancelTimer) {
                this.timer.cancel();
                this.timer = null;
                this.reentrantLock.unlock();
            }
        }
    }

    private void logError(Exception e) {
        if (this.reentrantLock.isLocked() || this.timer == null) {
            return;
        }
        LOGGER.warn("Error notifying JobStorageChangeListeners", (Throwable)e);
    }

    class NotifyOnChangeListeners
    extends TimerTask {
        NotifyOnChangeListeners() {
        }

        @Override
        public void run() {
            AbstractStorageProvider.this.notifyJobStatsOnChangeListeners();
            AbstractStorageProvider.this.notifyJobChangeListeners();
            AbstractStorageProvider.this.notifyBackgroundJobServerStatusChangeListeners();
            AbstractStorageProvider.this.notifyMetadataChangeListeners();
        }
    }
}

