/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.storage;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.locks.ReentrantLock;
import org.jobrunr.storage.JobStats;
import org.jobrunr.storage.JobStatsExtended;

public class JobStatsEnricher {
    private final ReentrantLock lock = new ReentrantLock();
    private JobStats firstRelevantJobStats;
    private JobStats previousJobStats;
    private JobStatsExtended jobStatsExtended;

    public JobStatsExtended enrich(JobStats jobStats) {
        JobStats latestJobStats = JobStatsEnricher.getLatestJobStats(jobStats, this.previousJobStats);
        if (this.lock.tryLock()) {
            this.setFirstRelevantJobStats(latestJobStats);
            this.setJobStatsExtended(latestJobStats);
            this.setPreviousJobStats(latestJobStats);
            this.lock.unlock();
        }
        return this.jobStatsExtended;
    }

    private static JobStats getLatestJobStats(JobStats jobStats, JobStats previousJobStats) {
        if (previousJobStats == null) {
            return jobStats;
        }
        if (jobStats.getTimeStamp().isAfter(previousJobStats.getTimeStamp())) {
            return jobStats;
        }
        return previousJobStats;
    }

    private void setFirstRelevantJobStats(JobStats jobStats) {
        if (this.firstRelevantJobStats == null || jobStats.getEnqueued() < 1L && jobStats.getProcessing() < 1L || jobStats.getEnqueued() > this.firstRelevantJobStats.getEnqueued()) {
            this.firstRelevantJobStats = jobStats;
        }
    }

    private void setJobStatsExtended(JobStats jobStats) {
        JobStats actualPreviousJobStats = this.previousJobStats != null ? this.previousJobStats : this.firstRelevantJobStats;
        Long amountSucceeded = jobStats.getSucceeded() - actualPreviousJobStats.getSucceeded();
        Long amountFailed = jobStats.getFailed() - actualPreviousJobStats.getFailed();
        Instant estimatedProcessingFinishedInstant = this.estimatedProcessingFinishedInstant(this.firstRelevantJobStats, jobStats);
        this.jobStatsExtended = estimatedProcessingFinishedInstant != null ? new JobStatsExtended(jobStats, amountSucceeded, amountFailed, estimatedProcessingFinishedInstant) : (this.jobStatsExtended != null && this.jobStatsExtended.getEstimation().isEstimatedProcessingFinishedInstantAvailable() ? new JobStatsExtended(jobStats, amountSucceeded, amountFailed, this.jobStatsExtended.getEstimation().getEstimatedProcessingFinishedAt()) : new JobStatsExtended(jobStats));
    }

    private Instant estimatedProcessingFinishedInstant(JobStats firstRelevantJobStats, JobStats jobStats) {
        if (jobStats.getSucceeded() - firstRelevantJobStats.getSucceeded() < 1L) {
            return null;
        }
        BigDecimal durationForAmountSucceededInSeconds = BigDecimal.valueOf(Duration.between(firstRelevantJobStats.getTimeStamp(), jobStats.getTimeStamp()).getSeconds());
        if (BigDecimal.ZERO.equals(durationForAmountSucceededInSeconds)) {
            return null;
        }
        BigDecimal amountSucceededPerSecond = BigDecimal.valueOf(Math.ceil(jobStats.getSucceeded() - firstRelevantJobStats.getSucceeded())).divide(durationForAmountSucceededInSeconds, RoundingMode.CEILING);
        if (BigDecimal.ZERO.equals(amountSucceededPerSecond)) {
            return null;
        }
        BigDecimal processingTimeInSeconds = BigDecimal.valueOf(jobStats.getEnqueued() + jobStats.getProcessing()).divide(amountSucceededPerSecond, RoundingMode.HALF_UP);
        return Instant.now().plusSeconds(processingTimeInSeconds.longValue());
    }

    private void setPreviousJobStats(JobStats jobStats) {
        this.previousJobStats = jobStats;
    }
}

