/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.storage.metrics;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import java.util.concurrent.atomic.AtomicLong;
import org.jobrunr.jobs.states.StateName;
import org.jobrunr.storage.JobStats;
import org.jobrunr.storage.StorageProvider;
import org.jobrunr.storage.listeners.JobStatsChangeListener;

public class StorageProviderMetricsBinder
implements JobStatsChangeListener,
AutoCloseable {
    private final StorageProvider storageProvider;
    private final MeterRegistry meterRegistry;
    private final AtomicLong scheduledGauge = new AtomicLong(0L);
    private final AtomicLong enqueuedGauge = new AtomicLong(0L);
    private final AtomicLong processingGauge = new AtomicLong(0L);
    private final AtomicLong failedGauge = new AtomicLong(0L);
    private final AtomicLong succeededGauge = new AtomicLong(0L);
    private final AtomicLong allTimeSucceededGauge = new AtomicLong(0L);
    private final AtomicLong deletedGauge = new AtomicLong(0L);

    public StorageProviderMetricsBinder(StorageProvider storageProvider, MeterRegistry meterRegistry) {
        this.storageProvider = storageProvider;
        this.meterRegistry = meterRegistry;
        this.registerStorageProviderMetrics();
    }

    public void registerStorageProviderMetrics() {
        this.registerGauge(StateName.SCHEDULED, this.scheduledGauge);
        this.registerGauge(StateName.ENQUEUED, this.enqueuedGauge);
        this.registerGauge(StateName.PROCESSING, this.processingGauge);
        this.registerGauge(StateName.FAILED, this.failedGauge);
        this.registerGauge(StateName.SUCCEEDED, this.succeededGauge);
        this.registerGauge("ALL_TIME_SUCCEEDED", this.allTimeSucceededGauge);
        this.registerGauge(StateName.DELETED, this.deletedGauge);
        this.onChange(this.storageProvider.getJobStats());
        this.storageProvider.addJobStorageOnChangeListener(this);
    }

    private void registerGauge(StateName stateName, AtomicLong number) {
        this.registerGauge(stateName.toString(), number);
    }

    private void registerGauge(String stateName, AtomicLong number) {
        this.meterRegistry.gauge("jobrunr.jobs." + stateName.toLowerCase(), (Iterable)Tags.of((String)"state", (String)stateName), (Number)number);
    }

    @Override
    public void onChange(JobStats jobStats) {
        this.scheduledGauge.set(jobStats.getScheduled());
        this.enqueuedGauge.set(jobStats.getEnqueued());
        this.processingGauge.set(jobStats.getProcessing());
        this.failedGauge.set(jobStats.getFailed());
        this.succeededGauge.set(jobStats.getSucceeded());
        this.allTimeSucceededGauge.set(jobStats.getAllTimeSucceeded());
        this.deletedGauge.set(jobStats.getDeleted());
    }

    @Override
    public void close() {
        this.storageProvider.removeJobStorageOnChangeListener(this);
    }
}

