/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.storage.nosql.common.migrations;

import java.io.IOException;
import org.jobrunr.storage.nosql.common.migrations.NoSqlMigration;
import org.jobrunr.utils.StringUtils;
import org.jobrunr.utils.reflection.ReflectionUtils;

public class NoSqlMigrationByZipEntry
implements NoSqlMigration {
    private final String name;
    private final String className;
    private final Class<?> migrationClass;

    public NoSqlMigrationByZipEntry(String name) throws ClassNotFoundException {
        this.name = name;
        this.className = StringUtils.substringAfterLast(name, "/");
        this.migrationClass = ReflectionUtils.loadClass(ReflectionUtils.toClassNameFromFileName(name));
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public Class<?> getMigrationClass() throws IOException, ClassNotFoundException {
        return this.migrationClass;
    }

    public String toString() {
        return "NoSqlMigrationByZipEntry{zipFile=" + this.name + '}';
    }
}

