/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.storage.nosql.documentdb;

import com.mongodb.MongoClientSettings;
import com.mongodb.MongoCredential;
import com.mongodb.ReadPreference;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import java.util.Collections;
import org.bson.UuidRepresentation;
import org.bson.codecs.Codec;
import org.bson.codecs.UuidCodec;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.jobrunr.storage.StorageProviderUtils;
import org.jobrunr.storage.nosql.mongo.MongoDBStorageProvider;
import org.jobrunr.utils.resilience.RateLimiter;

public class AmazonDocumentDBStorageProvider
extends MongoDBStorageProvider {
    public AmazonDocumentDBStorageProvider(String hostName, int port) {
        super(hostName, port);
    }

    public AmazonDocumentDBStorageProvider(MongoClient mongoClient) {
        super(mongoClient);
    }

    public AmazonDocumentDBStorageProvider(MongoClient mongoClient, String dbName) {
        super(mongoClient, dbName);
    }

    public AmazonDocumentDBStorageProvider(MongoClient mongoClient, String dbName, StorageProviderUtils.DatabaseOptions databaseOptions) {
        super(mongoClient, dbName, databaseOptions);
    }

    public AmazonDocumentDBStorageProvider(MongoClient mongoClient, String dbName, String collectionPrefix) {
        super(mongoClient, dbName, collectionPrefix);
    }

    public AmazonDocumentDBStorageProvider(MongoClient mongoClient, String dbName, String collectionPrefix, StorageProviderUtils.DatabaseOptions databaseOptions) {
        super(mongoClient, dbName, collectionPrefix, databaseOptions);
    }

    public AmazonDocumentDBStorageProvider(MongoClient mongoClient, RateLimiter changeListenerNotificationRateLimit) {
        super(mongoClient, changeListenerNotificationRateLimit);
    }

    public AmazonDocumentDBStorageProvider(MongoClient mongoClient, StorageProviderUtils.DatabaseOptions databaseOptions, RateLimiter changeListenerNotificationRateLimit) {
        super(mongoClient, databaseOptions, changeListenerNotificationRateLimit);
    }

    public AmazonDocumentDBStorageProvider(MongoClient mongoClient, String dbName, String collectionPrefix, StorageProviderUtils.DatabaseOptions databaseOptions, RateLimiter changeListenerNotificationRateLimit) {
        super(mongoClient, dbName, collectionPrefix, databaseOptions, changeListenerNotificationRateLimit);
    }

    public static AmazonDocumentDBStorageProvider amazonDocumentDBStorageProviderWithDefaultSetting(String hostName, int port, MongoCredential credential) {
        return new AmazonDocumentDBStorageProvider(AmazonDocumentDBStorageProvider.getDocumentDBDefaultSetting(new ServerAddress(hostName, port), credential));
    }

    public static AmazonDocumentDBStorageProvider amazonDocumentDBStorageProviderWithDefaultSetting(String hostName, int port, MongoCredential credential, String dbName) {
        return new AmazonDocumentDBStorageProvider(AmazonDocumentDBStorageProvider.getDocumentDBDefaultSetting(new ServerAddress(hostName, port), credential), dbName);
    }

    private static MongoClient getDocumentDBDefaultSetting(ServerAddress serverAddress, MongoCredential credential) {
        return MongoClients.create((MongoClientSettings)MongoClientSettings.builder().applyToClusterSettings(builder -> builder.hosts(Collections.singletonList(serverAddress))).credential(credential).codecRegistry(CodecRegistries.fromRegistries((CodecRegistry[])new CodecRegistry[]{CodecRegistries.fromCodecs((Codec[])new Codec[]{new UuidCodec(UuidRepresentation.STANDARD)}), MongoClientSettings.getDefaultCodecRegistry()})).retryWrites(false).readPreference(ReadPreference.secondaryPreferred()).build());
    }
}

