/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.storage.nosql.elasticsearch;

import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.UUID;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.common.document.DocumentField;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.json.JsonXContent;
import org.jobrunr.jobs.Job;
import org.jobrunr.jobs.RecurringJob;
import org.jobrunr.jobs.mappers.JobMapper;
import org.jobrunr.jobs.states.ScheduledState;
import org.jobrunr.jobs.states.StateName;
import org.jobrunr.storage.BackgroundJobServerStatus;
import org.jobrunr.storage.JobRunrMetadata;
import org.jobrunr.utils.reflection.ReflectionUtils;

public class ElasticSearchDocumentMapper {
    private final JobMapper jobMapper;

    public ElasticSearchDocumentMapper(JobMapper jobMapper) {
        this.jobMapper = jobMapper;
    }

    public XContentBuilder toXContentBuilderForInsert(BackgroundJobServerStatus serverStatus) {
        try {
            XContentBuilder builder = JsonXContent.contentBuilder().prettyPrint();
            builder.startObject();
            builder.field("id", serverStatus.getId().toString());
            builder.field("workerPoolSize", serverStatus.getWorkerPoolSize());
            builder.field("pollIntervalInSeconds", serverStatus.getPollIntervalInSeconds());
            builder.field("deleteSucceededJobsAfter", (Object)serverStatus.getDeleteSucceededJobsAfter());
            builder.field("permanentlyDeleteDeletedJobsAfter", (Object)serverStatus.getPermanentlyDeleteDeletedJobsAfter());
            builder.field("firstHeartbeat", (Object)serverStatus.getFirstHeartbeat());
            builder.field("lastHeartbeat", (Object)serverStatus.getLastHeartbeat());
            builder.field("running", serverStatus.isRunning());
            builder.field("systemTotalMemory", serverStatus.getSystemTotalMemory());
            builder.field("systemFreeMemory", serverStatus.getSystemFreeMemory());
            builder.field("systemCpuLoad", serverStatus.getSystemCpuLoad());
            builder.field("processMaxMemory", serverStatus.getProcessMaxMemory());
            builder.field("processFreeMemory", serverStatus.getProcessFreeMemory());
            builder.field("processAllocatedMemory", serverStatus.getProcessAllocatedMemory());
            builder.field("processCpuLoad", serverStatus.getProcessCpuLoad());
            builder.endObject();
            return builder;
        }
        catch (IOException e) {
            throw new ShouldNotHappenException(e);
        }
    }

    public XContentBuilder toXContentBuilderForUpdate(BackgroundJobServerStatus serverStatus) {
        try {
            XContentBuilder builder = JsonXContent.contentBuilder().prettyPrint();
            builder.startObject();
            builder.field("lastHeartbeat", (Object)serverStatus.getLastHeartbeat());
            builder.field("systemFreeMemory", serverStatus.getSystemFreeMemory());
            builder.field("systemCpuLoad", serverStatus.getSystemCpuLoad());
            builder.field("processFreeMemory", serverStatus.getProcessFreeMemory());
            builder.field("processAllocatedMemory", serverStatus.getProcessAllocatedMemory());
            builder.field("processCpuLoad", serverStatus.getProcessCpuLoad());
            builder.endObject();
            return builder;
        }
        catch (IOException e) {
            throw new ShouldNotHappenException(e);
        }
    }

    public XContentBuilder toXContentBuilder(Job job) {
        try {
            XContentBuilder builder = JsonXContent.contentBuilder().prettyPrint();
            builder.startObject();
            builder.field("jobAsJson", this.jobMapper.serializeJob(job));
            builder.field("state", (Enum)job.getState());
            builder.field("updatedAt", (Object)job.getUpdatedAt());
            builder.field("jobSignature", job.getJobSignature());
            if (job.hasState(StateName.SCHEDULED)) {
                builder.field("scheduledAt", (Object)job.getLastJobStateOfType(ScheduledState.class).map(ScheduledState::getScheduledAt).orElseThrow(IllegalStateException::new));
            }
            if (job.getRecurringJobId().isPresent()) {
                builder.field("recurringJobId", job.getRecurringJobId().get());
            }
            builder.endObject();
            return builder;
        }
        catch (IOException e) {
            throw new ShouldNotHappenException(e);
        }
    }

    public XContentBuilder toXContentBuilder(JobRunrMetadata metadata) {
        try {
            XContentBuilder builder = JsonXContent.contentBuilder().prettyPrint();
            builder.startObject();
            builder.field("name", metadata.getName());
            builder.field("owner", metadata.getOwner());
            builder.field("value", metadata.getValue());
            builder.field("createdAt", (Object)metadata.getCreatedAt());
            builder.field("updatedAt", (Object)metadata.getUpdatedAt());
            builder.endObject();
            return builder;
        }
        catch (IOException e) {
            throw new ShouldNotHappenException(e);
        }
    }

    public XContentBuilder toXContentBuilder(RecurringJob job) {
        try {
            XContentBuilder builder = JsonXContent.contentBuilder().prettyPrint();
            builder.startObject();
            builder.field("jobAsJson", this.jobMapper.serializeRecurringJob(job));
            builder.endObject();
            return builder;
        }
        catch (IOException e) {
            throw new ShouldNotHappenException(e);
        }
    }

    public BackgroundJobServerStatus toBackgroundJobServerStatus(SearchHit searchHit) {
        Map fieldMap = searchHit.getSourceAsMap();
        return new BackgroundJobServerStatus(ReflectionUtils.autobox(fieldMap.get("id"), UUID.class), ReflectionUtils.autobox(fieldMap.get("workerPoolSize"), Integer.TYPE), ReflectionUtils.autobox(fieldMap.get("pollIntervalInSeconds"), Integer.TYPE), ReflectionUtils.autobox(fieldMap.get("deleteSucceededJobsAfter"), Duration.class), ReflectionUtils.autobox(fieldMap.get("permanentlyDeleteDeletedJobsAfter"), Duration.class), ReflectionUtils.autobox(fieldMap.get("firstHeartbeat"), Instant.class), ReflectionUtils.autobox(fieldMap.get("lastHeartbeat"), Instant.class), ReflectionUtils.autobox(fieldMap.get("running"), Boolean.TYPE), ReflectionUtils.autobox(fieldMap.get("systemTotalMemory"), Long.TYPE), ReflectionUtils.autobox(fieldMap.get("systemFreeMemory"), Long.TYPE), ReflectionUtils.autobox(fieldMap.get("systemCpuLoad"), Double.TYPE), ReflectionUtils.autobox(fieldMap.get("processMaxMemory"), Long.TYPE), ReflectionUtils.autobox(fieldMap.get("processFreeMemory"), Long.TYPE), ReflectionUtils.autobox(fieldMap.get("processAllocatedMemory"), Long.TYPE), ReflectionUtils.autobox(fieldMap.get("processCpuLoad"), Double.TYPE));
    }

    public JobRunrMetadata toMetadata(SearchHit searchHit) {
        return this.toMetadata(searchHit.getSourceAsMap());
    }

    public JobRunrMetadata toMetadata(GetResponse response) {
        return this.toMetadata(response.getSourceAsMap());
    }

    public JobRunrMetadata toMetadata(Map<String, Object> fieldMap) {
        return new JobRunrMetadata(ReflectionUtils.autobox(fieldMap.get("name"), String.class), ReflectionUtils.autobox(fieldMap.get("owner"), String.class), ReflectionUtils.autobox(fieldMap.get("value"), String.class), ReflectionUtils.autobox(fieldMap.get("createdAt"), Instant.class), ReflectionUtils.autobox(fieldMap.get("updatedAt"), Instant.class));
    }

    public Job toJob(GetResponse response) {
        return this.jobMapper.deserializeJob((String)response.getField("jobAsJson").getValue());
    }

    public Job toJob(SearchHit hit) {
        String jobAsJson = ((DocumentField)hit.getFields().get("jobAsJson")).getValue().toString();
        return this.jobMapper.deserializeJob(jobAsJson);
    }

    public RecurringJob toRecurringJob(SearchHit hit) {
        String jobAsJson = ((DocumentField)hit.getFields().get("jobAsJson")).getValue().toString();
        return this.jobMapper.deserializeRecurringJob(jobAsJson);
    }

    static class ShouldNotHappenException
    extends RuntimeException {
        public ShouldNotHappenException(Exception e) {
            super("Should never happen", e);
        }
    }
}

