/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.storage.nosql.elasticsearch;

import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.http.HttpHost;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.core.CountRequest;
import org.elasticsearch.client.core.CountResponse;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptType;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.jobrunr.jobs.Job;
import org.jobrunr.jobs.JobDetails;
import org.jobrunr.jobs.JobListVersioner;
import org.jobrunr.jobs.JobVersioner;
import org.jobrunr.jobs.RecurringJob;
import org.jobrunr.jobs.mappers.JobMapper;
import org.jobrunr.jobs.states.StateName;
import org.jobrunr.storage.AbstractStorageProvider;
import org.jobrunr.storage.BackgroundJobServerStatus;
import org.jobrunr.storage.ConcurrentJobModificationException;
import org.jobrunr.storage.JobNotFoundException;
import org.jobrunr.storage.JobRunrMetadata;
import org.jobrunr.storage.JobStats;
import org.jobrunr.storage.Page;
import org.jobrunr.storage.PageRequest;
import org.jobrunr.storage.ServerTimedOutException;
import org.jobrunr.storage.StorageException;
import org.jobrunr.storage.StorageProviderUtils;
import org.jobrunr.storage.nosql.NoSqlStorageProvider;
import org.jobrunr.storage.nosql.elasticsearch.ElasticSearchDBCreator;
import org.jobrunr.storage.nosql.elasticsearch.ElasticSearchDocumentMapper;
import org.jobrunr.utils.JobUtils;
import org.jobrunr.utils.reflection.ReflectionUtils;
import org.jobrunr.utils.resilience.RateLimiter;

public class ElasticSearchStorageProvider
extends AbstractStorageProvider
implements NoSqlStorageProvider {
    public static final String DEFAULT_JOB_INDEX_NAME = "jobrunr_jobs";
    public static final String DEFAULT_RECURRING_JOB_INDEX_NAME = "jobrunr_recurring_jobs";
    public static final String DEFAULT_BACKGROUND_JOB_SERVER_INDEX_NAME = "jobrunr_background_job_servers";
    public static final String DEFAULT_METADATA_INDEX_NAME = "jobrunr_metadata";
    private final RestHighLevelClient client;
    private final String jobIndexName;
    private final String recurringJobIndexName;
    private final String backgroundJobServerIndexName;
    private final String metadataIndexName;
    private final String indexPrefix;
    private ElasticSearchDocumentMapper elasticSearchDocumentMapper;

    public ElasticSearchStorageProvider(String hostName, int port) {
        this(new HttpHost(hostName, port, "http"));
    }

    public ElasticSearchStorageProvider(HttpHost httpHost) {
        this(new RestHighLevelClient(RestClient.builder((HttpHost[])new HttpHost[]{httpHost})));
    }

    public ElasticSearchStorageProvider(RestHighLevelClient client) {
        this(client, (String)null);
    }

    public ElasticSearchStorageProvider(RestHighLevelClient client, String indexPrefix) {
        this(client, indexPrefix, StorageProviderUtils.DatabaseOptions.CREATE, RateLimiter.Builder.rateLimit().at1Request().per(RateLimiter.SECOND));
    }

    public ElasticSearchStorageProvider(RestHighLevelClient client, String indexPrefix, StorageProviderUtils.DatabaseOptions databaseOptions) {
        this(client, indexPrefix, databaseOptions, RateLimiter.Builder.rateLimit().at1Request().per(RateLimiter.SECOND));
    }

    public ElasticSearchStorageProvider(RestHighLevelClient client, StorageProviderUtils.DatabaseOptions databaseOptions) {
        this(client, null, databaseOptions, RateLimiter.Builder.rateLimit().at1Request().per(RateLimiter.SECOND));
    }

    public ElasticSearchStorageProvider(RestHighLevelClient client, StorageProviderUtils.DatabaseOptions databaseOptions, RateLimiter rateLimiter) {
        this(client, null, databaseOptions, rateLimiter);
    }

    public ElasticSearchStorageProvider(RestHighLevelClient client, String indexPrefix, StorageProviderUtils.DatabaseOptions databaseOptions, RateLimiter changeListenerNotificationRateLimit) {
        super(changeListenerNotificationRateLimit);
        this.client = client;
        this.indexPrefix = indexPrefix;
        this.setUpStorageProvider(databaseOptions);
        this.jobIndexName = StorageProviderUtils.elementPrefixer(indexPrefix, DEFAULT_JOB_INDEX_NAME);
        this.recurringJobIndexName = StorageProviderUtils.elementPrefixer(indexPrefix, DEFAULT_RECURRING_JOB_INDEX_NAME);
        this.backgroundJobServerIndexName = StorageProviderUtils.elementPrefixer(indexPrefix, DEFAULT_BACKGROUND_JOB_SERVER_INDEX_NAME);
        this.metadataIndexName = StorageProviderUtils.elementPrefixer(indexPrefix, DEFAULT_METADATA_INDEX_NAME);
    }

    @Override
    public void setJobMapper(JobMapper jobMapper) {
        this.elasticSearchDocumentMapper = new ElasticSearchDocumentMapper(jobMapper);
    }

    @Override
    public void setUpStorageProvider(StorageProviderUtils.DatabaseOptions databaseOptions) {
        if (StorageProviderUtils.DatabaseOptions.CREATE == databaseOptions) {
            new ElasticSearchDBCreator(this, this.client, this.indexPrefix).runMigrations();
        } else {
            new ElasticSearchDBCreator(this, this.client, this.indexPrefix).validateIndices();
        }
    }

    @Override
    public void announceBackgroundJobServer(BackgroundJobServerStatus serverStatus) {
        try {
            IndexRequest request = ((IndexRequest)new IndexRequest(this.backgroundJobServerIndexName).id(serverStatus.getId().toString()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(this.elasticSearchDocumentMapper.toXContentBuilderForInsert(serverStatus));
            this.client.index(request, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public boolean signalBackgroundJobServerAlive(BackgroundJobServerStatus serverStatus) {
        try {
            UpdateRequest updateRequest = new UpdateRequest(this.backgroundJobServerIndexName, serverStatus.getId().toString()).fetchSource(true).doc(this.elasticSearchDocumentMapper.toXContentBuilderForUpdate(serverStatus));
            UpdateResponse updateResponse = this.client.update(updateRequest, RequestOptions.DEFAULT);
            return (Boolean)ReflectionUtils.cast(updateResponse.getGetResult().getSource().getOrDefault("running", false));
        }
        catch (ElasticsearchStatusException e) {
            if (e.status().getStatus() == 404) {
                throw new ServerTimedOutException(serverStatus, new StorageException(e));
            }
            throw e;
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public void signalBackgroundJobServerStopped(BackgroundJobServerStatus serverStatus) {
        try {
            DeleteRequest deleteRequest = new DeleteRequest(this.backgroundJobServerIndexName, serverStatus.getId().toString());
            this.client.delete((DeleteRequest)deleteRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE), RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public List<BackgroundJobServerStatus> getBackgroundJobServers() {
        try {
            SearchRequest searchRequest = new SearchRequest(new String[]{this.backgroundJobServerIndexName});
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
            searchSourceBuilder.query((QueryBuilder)QueryBuilders.matchAllQuery());
            searchSourceBuilder.fetchSource(true);
            searchSourceBuilder.sort("firstHeartbeat", SortOrder.ASC);
            searchRequest.source(searchSourceBuilder);
            SearchResponse search = this.client.search(searchRequest, RequestOptions.DEFAULT);
            return Stream.of(search.getHits().getHits()).map(this.elasticSearchDocumentMapper::toBackgroundJobServerStatus).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public UUID getLongestRunningBackgroundJobServerId() {
        try {
            SearchRequest searchRequest = new SearchRequest(new String[]{this.backgroundJobServerIndexName});
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
            searchSourceBuilder.query((QueryBuilder)QueryBuilders.matchAllQuery());
            searchSourceBuilder.fetchSource(false);
            searchSourceBuilder.sort("firstHeartbeat", SortOrder.ASC);
            searchSourceBuilder.size(1);
            searchRequest.source(searchSourceBuilder);
            SearchResponse search = this.client.search(searchRequest, RequestOptions.DEFAULT);
            return UUID.fromString(search.getHits().getHits()[0].getId());
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public int removeTimedOutBackgroundJobServers(Instant heartbeatOlderThan) {
        try {
            DeleteByQueryRequest deleteByQueryRequest = new DeleteByQueryRequest(new String[]{this.backgroundJobServerIndexName});
            deleteByQueryRequest.setQuery((QueryBuilder)QueryBuilders.rangeQuery((String)"lastHeartbeat").to((Object)heartbeatOlderThan));
            BulkByScrollResponse bulkByScrollResponse = this.client.deleteByQuery(deleteByQueryRequest, RequestOptions.DEFAULT);
            int amountDeleted = (int)bulkByScrollResponse.getDeleted();
            if (amountDeleted > 0) {
                RefreshRequest request = new RefreshRequest(new String[]{this.backgroundJobServerIndexName});
                this.client.indices().refresh(request, RequestOptions.DEFAULT);
            }
            this.notifyJobStatsOnChangeListenersIf(amountDeleted > 0);
            return amountDeleted;
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public void saveMetadata(JobRunrMetadata metadata) {
        try {
            IndexRequest request = ((IndexRequest)new IndexRequest(this.metadataIndexName).id(metadata.getId()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(this.elasticSearchDocumentMapper.toXContentBuilder(metadata));
            this.client.index(request, RequestOptions.DEFAULT);
            this.notifyMetadataChangeListeners();
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public List<JobRunrMetadata> getMetadata(String name) {
        try {
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
            searchSourceBuilder.query((QueryBuilder)QueryBuilders.matchQuery((String)"name", (Object)name));
            SearchRequest searchRequest = new SearchRequest(new String[]{this.metadataIndexName});
            searchRequest.source(searchSourceBuilder);
            SearchResponse searchResponse = this.client.search(searchRequest, RequestOptions.DEFAULT);
            return Stream.of(searchResponse.getHits().getHits()).map(this.elasticSearchDocumentMapper::toMetadata).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public JobRunrMetadata getMetadata(String name, String owner) {
        try {
            GetResponse response = this.client.get(new GetRequest(this.metadataIndexName, JobRunrMetadata.toId(name, owner)), RequestOptions.DEFAULT);
            return this.elasticSearchDocumentMapper.toMetadata(response);
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public void deleteMetadata(String name) {
        try {
            DeleteByQueryRequest deleteByQueryRequest = new DeleteByQueryRequest(new String[]{this.metadataIndexName});
            deleteByQueryRequest.setQuery((QueryBuilder)QueryBuilders.matchQuery((String)"name", (Object)name));
            BulkByScrollResponse bulkByScrollResponse = this.client.deleteByQuery(deleteByQueryRequest, RequestOptions.DEFAULT);
            int amountDeleted = (int)bulkByScrollResponse.getDeleted();
            if (amountDeleted > 0) {
                RefreshRequest request = new RefreshRequest(new String[]{this.metadataIndexName});
                this.client.indices().refresh(request, RequestOptions.DEFAULT);
                this.notifyMetadataChangeListeners();
            }
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public Job save(Job job) {
        JobVersioner jobVersioner = new JobVersioner(job);
        try {
            IndexRequest request = ((IndexRequest)new IndexRequest(this.jobIndexName).id(job.getId().toString()).versionType(VersionType.EXTERNAL).version((long)job.getVersion()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(this.elasticSearchDocumentMapper.toXContentBuilder(job));
            this.client.index(request, RequestOptions.DEFAULT);
            jobVersioner.commitVersion();
            this.notifyJobStatsOnChangeListeners();
            Job job2 = job;
            jobVersioner.close();
            return job2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    jobVersioner.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (ElasticsearchException e) {
                if (e.status().getStatus() == 409) {
                    throw new ConcurrentJobModificationException(job);
                }
                throw new StorageException(e);
            }
            catch (IOException e) {
                throw new StorageException(e);
            }
        }
    }

    @Override
    public int deletePermanently(UUID id) {
        try {
            DeleteResponse delete = this.client.delete((DeleteRequest)new DeleteRequest(this.jobIndexName, id.toString()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE), RequestOptions.DEFAULT);
            int amountDeleted = delete.getShardInfo().getSuccessful();
            this.notifyJobStatsOnChangeListenersIf(amountDeleted > 0);
            return amountDeleted;
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public Job getJobById(UUID id) {
        try {
            GetRequest request = new GetRequest(this.jobIndexName, id.toString());
            request.storedFields(new String[]{"jobAsJson"});
            GetResponse response = this.client.get(request, RequestOptions.DEFAULT);
            if (response.isExists()) {
                return this.elasticSearchDocumentMapper.toJob(response);
            }
            throw new JobNotFoundException(id);
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public List<Job> save(List<Job> jobs) {
        JobListVersioner jobListVersioner = new JobListVersioner(jobs);
        try {
            jobListVersioner.validateJobs();
            BulkRequest bulkRequest = new BulkRequest(this.jobIndexName).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            jobs.stream().map(job -> new IndexRequest().id(job.getId().toString()).versionType(VersionType.EXTERNAL).version((long)job.getVersion()).source(this.elasticSearchDocumentMapper.toXContentBuilder((Job)job))).forEach(arg_0 -> ((BulkRequest)bulkRequest).add(arg_0));
            BulkResponse bulk = this.client.bulk(bulkRequest, RequestOptions.DEFAULT);
            List<Job> concurrentModifiedJobs = Stream.of(bulk.getItems()).filter(item -> item.isFailed() && item.status().getStatus() == 409).map(item -> (Job)jobs.get(item.getItemId())).collect(Collectors.toList());
            if (!concurrentModifiedJobs.isEmpty()) {
                jobListVersioner.rollbackVersions(concurrentModifiedJobs);
                throw new ConcurrentJobModificationException(concurrentModifiedJobs);
            }
            jobListVersioner.commitVersions();
            this.notifyJobStatsOnChangeListenersIf(!jobs.isEmpty());
            List<Job> list = jobs;
            jobListVersioner.close();
            return list;
        }
        catch (Throwable throwable) {
            try {
                try {
                    jobListVersioner.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | ElasticsearchException e) {
                throw new StorageException(e);
            }
        }
    }

    @Override
    public List<Job> getJobs(StateName state, Instant updatedBefore, PageRequest pageRequest) {
        try {
            BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.matchQuery((String)"state", (Object)((Object)state))).must((QueryBuilder)QueryBuilders.rangeQuery((String)"updatedAt").to((Object)updatedBefore));
            SearchResponse searchResponse = this.searchJobs((QueryBuilder)boolQueryBuilder, pageRequest);
            return Stream.of(searchResponse.getHits().getHits()).map(this.elasticSearchDocumentMapper::toJob).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public List<Job> getScheduledJobs(Instant scheduledBefore, PageRequest pageRequest) {
        try {
            RangeQueryBuilder scheduledBeforeQuery = QueryBuilders.rangeQuery((String)"scheduledAt").to((Object)scheduledBefore);
            SearchResponse searchResponse = this.searchJobs((QueryBuilder)scheduledBeforeQuery, pageRequest);
            return Stream.of(searchResponse.getHits().getHits()).map(this.elasticSearchDocumentMapper::toJob).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public List<Job> getJobs(StateName state, PageRequest pageRequest) {
        try {
            BoolQueryBuilder stateQuery = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.matchQuery((String)"state", (Object)((Object)state)));
            SearchResponse searchResponse = this.searchJobs((QueryBuilder)stateQuery, pageRequest);
            return Stream.of(searchResponse.getHits().getHits()).map(this.elasticSearchDocumentMapper::toJob).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public Page<Job> getJobPage(StateName state, PageRequest pageRequest) {
        try {
            long count = this.countJobs((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.matchQuery((String)"state", (Object)((Object)state))));
            if (count > 0L) {
                List<Job> jobs = this.getJobs(state, pageRequest);
                return new Page<Job>(count, jobs, pageRequest);
            }
            return new Page<Job>(0L, new ArrayList(), pageRequest);
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public int deleteJobsPermanently(StateName state, Instant updatedBefore) {
        try {
            BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.matchQuery((String)"state", (Object)((Object)state))).must((QueryBuilder)QueryBuilders.rangeQuery((String)"updatedAt").to((Object)updatedBefore));
            DeleteByQueryRequest deleteByQueryRequest = new DeleteByQueryRequest(new String[]{this.jobIndexName});
            deleteByQueryRequest.setQuery((QueryBuilder)boolQueryBuilder);
            BulkByScrollResponse bulkByScrollResponse = this.client.deleteByQuery(deleteByQueryRequest, RequestOptions.DEFAULT);
            int amountDeleted = (int)bulkByScrollResponse.getDeleted();
            if (amountDeleted > 0) {
                RefreshRequest request = new RefreshRequest(new String[]{this.jobIndexName});
                this.client.indices().refresh(request, RequestOptions.DEFAULT);
            }
            this.notifyJobStatsOnChangeListenersIf(amountDeleted > 0);
            return amountDeleted;
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public Set<String> getDistinctJobSignatures(StateName ... states) {
        try {
            BoolQueryBuilder stateQuery = QueryBuilders.boolQuery();
            for (StateName state : states) {
                stateQuery.should((QueryBuilder)QueryBuilders.matchQuery((String)"state", (Object)((Object)state)));
            }
            SearchRequest searchRequest = new SearchRequest(new String[]{this.jobIndexName});
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
            searchSourceBuilder.query((QueryBuilder)stateQuery);
            searchSourceBuilder.aggregation((AggregationBuilder)AggregationBuilders.terms((String)"jobSignature").field("jobSignature"));
            searchRequest.source(searchSourceBuilder);
            SearchResponse searchResponse = this.client.search(searchRequest, RequestOptions.DEFAULT);
            Terms terms = (Terms)searchResponse.getAggregations().get("jobSignature");
            return terms.getBuckets().stream().map(MultiBucketsAggregation.Bucket::getKeyAsString).collect(Collectors.toSet());
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public boolean exists(JobDetails jobDetails, StateName ... states) {
        try {
            BoolQueryBuilder stateQuery = QueryBuilders.boolQuery();
            for (StateName state : states) {
                stateQuery.should((QueryBuilder)QueryBuilders.matchQuery((String)"state", (Object)((Object)state)));
            }
            BoolQueryBuilder stateAndJobSignatureQuery = QueryBuilders.boolQuery().must((QueryBuilder)stateQuery).must((QueryBuilder)QueryBuilders.matchQuery((String)"jobSignature", (Object)JobUtils.getJobSignature(jobDetails)));
            return this.countJobs((QueryBuilder)stateAndJobSignatureQuery) > 0L;
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public boolean recurringJobExists(String recurringJobId, StateName ... states) {
        try {
            BoolQueryBuilder stateQuery = QueryBuilders.boolQuery();
            for (StateName state : states) {
                stateQuery.should((QueryBuilder)QueryBuilders.matchQuery((String)"state", (Object)((Object)state)));
            }
            BoolQueryBuilder stateAndJobSignatureQuery = QueryBuilders.boolQuery().must((QueryBuilder)stateQuery).must((QueryBuilder)QueryBuilders.matchQuery((String)"recurringJobId", (Object)recurringJobId));
            return this.countJobs((QueryBuilder)stateAndJobSignatureQuery) > 0L;
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public RecurringJob saveRecurringJob(RecurringJob recurringJob) {
        try {
            IndexRequest request = ((IndexRequest)new IndexRequest(this.recurringJobIndexName).id(recurringJob.getId()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(this.elasticSearchDocumentMapper.toXContentBuilder(recurringJob));
            this.client.index(request, RequestOptions.DEFAULT);
            return recurringJob;
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public List<RecurringJob> getRecurringJobs() {
        try {
            SearchRequest searchRequest = new SearchRequest(new String[]{this.recurringJobIndexName});
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
            searchSourceBuilder.query((QueryBuilder)QueryBuilders.matchAllQuery());
            searchSourceBuilder.storedField("jobAsJson");
            searchRequest.source(searchSourceBuilder);
            SearchResponse search = this.client.search(searchRequest, RequestOptions.DEFAULT);
            return Stream.of(search.getHits().getHits()).map(this.elasticSearchDocumentMapper::toRecurringJob).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public long countRecurringJobs() {
        try {
            return this.client.count(new CountRequest(new String[]{this.recurringJobIndexName}), RequestOptions.DEFAULT).getCount();
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public int deleteRecurringJob(String id) {
        try {
            DeleteResponse delete = this.client.delete((DeleteRequest)new DeleteRequest(this.recurringJobIndexName, id).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE), RequestOptions.DEFAULT);
            int amountDeleted = delete.getShardInfo().getSuccessful();
            this.notifyJobStatsOnChangeListenersIf(amountDeleted > 0);
            return amountDeleted;
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public JobStats getJobStats() {
        try {
            GetResponse getResponse = this.client.get(new GetRequest(this.metadataIndexName, "succeeded-jobs-counter-cluster"), RequestOptions.DEFAULT);
            SearchRequest searchRequest = new SearchRequest(new String[]{this.jobIndexName});
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
            searchSourceBuilder.query((QueryBuilder)QueryBuilders.matchAllQuery());
            searchSourceBuilder.aggregation((AggregationBuilder)AggregationBuilders.terms((String)"state").field("state"));
            searchRequest.source(searchSourceBuilder);
            SearchResponse searchResponse = this.client.search(searchRequest, RequestOptions.DEFAULT);
            Terms terms = (Terms)searchResponse.getAggregations().get("state");
            List buckets = terms.getBuckets();
            return new JobStats(Instant.now(), 0L, buckets.stream().filter(bucket -> StateName.SCHEDULED.name().equals(bucket.getKeyAsString())).map(MultiBucketsAggregation.Bucket::getDocCount).findFirst().orElse(0L), buckets.stream().filter(bucket -> StateName.ENQUEUED.name().equals(bucket.getKeyAsString())).map(MultiBucketsAggregation.Bucket::getDocCount).findFirst().orElse(0L), buckets.stream().filter(bucket -> StateName.PROCESSING.name().equals(bucket.getKeyAsString())).map(MultiBucketsAggregation.Bucket::getDocCount).findFirst().orElse(0L), buckets.stream().filter(bucket -> StateName.FAILED.name().equals(bucket.getKeyAsString())).map(MultiBucketsAggregation.Bucket::getDocCount).findFirst().orElse(0L), buckets.stream().filter(bucket -> StateName.SUCCEEDED.name().equals(bucket.getKeyAsString())).map(MultiBucketsAggregation.Bucket::getDocCount).findFirst().orElse(0L), ((Number)getResponse.getSource().getOrDefault("value", 0L)).longValue(), buckets.stream().filter(bucket -> StateName.DELETED.name().equals(bucket.getKeyAsString())).map(MultiBucketsAggregation.Bucket::getDocCount).findFirst().orElse(0L), (int)this.client.count(new CountRequest(new String[]{this.recurringJobIndexName}), RequestOptions.DEFAULT).getCount(), (int)this.client.count(new CountRequest(new String[]{this.backgroundJobServerIndexName}), RequestOptions.DEFAULT).getCount());
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public void publishTotalAmountOfSucceededJobs(int amount) {
        try {
            UpdateRequest updateRequest = new UpdateRequest(this.metadataIndexName, "succeeded-jobs-counter-cluster");
            updateRequest.scriptedUpsert(true);
            Map<String, Integer> parameters = Collections.singletonMap("value", amount);
            Script inline = new Script(ScriptType.INLINE, "painless", "ctx._source.value += params.value", parameters);
            updateRequest.script(inline);
            this.client.update(updateRequest, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    long countJobs(QueryBuilder queryBuilder) throws IOException {
        CountRequest countRequest = new CountRequest(new String[]{this.jobIndexName});
        countRequest.query(queryBuilder);
        CountResponse countResponse = this.client.count(countRequest, RequestOptions.DEFAULT);
        return countResponse.getCount();
    }

    SearchResponse searchJobs(QueryBuilder queryBuilder, PageRequest pageRequest) throws IOException {
        SearchRequest searchRequest = new SearchRequest(new String[]{this.jobIndexName});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query(queryBuilder);
        searchSourceBuilder.from((int)pageRequest.getOffset());
        searchSourceBuilder.size(pageRequest.getLimit());
        searchSourceBuilder.storedField("jobAsJson");
        if (pageRequest.getOrder().equals("updatedAt:ASC")) {
            searchSourceBuilder.sort("updatedAt", SortOrder.ASC);
        } else if (pageRequest.getOrder().equals("updatedAt:DESC")) {
            searchSourceBuilder.sort("updatedAt", SortOrder.DESC);
        } else {
            throw new IllegalArgumentException("Unknown sort: " + pageRequest.getOrder());
        }
        searchRequest.source(searchSourceBuilder);
        return this.client.search(searchRequest, RequestOptions.DEFAULT);
    }
}

