/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.storage.nosql.elasticsearch.migrations;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.GetIndexRequest;
import org.jobrunr.storage.StorageException;
import org.jobrunr.storage.nosql.elasticsearch.ElasticSearchUtils;

public abstract class ElasticSearchMigration {
    public abstract void runMigration(RestHighLevelClient var1, String var2) throws IOException;

    public static void waitForHealthyCluster(RestHighLevelClient restHighLevelClient) {
        try {
            ClusterHealthRequest clusterHealthRequest = new ClusterHealthRequest();
            clusterHealthRequest.waitForYellowStatus();
            restHighLevelClient.cluster().health(clusterHealthRequest, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    public static boolean indexExists(RestHighLevelClient client, String name) {
        ElasticSearchMigration.waitForHealthyCluster(client);
        try {
            return client.indices().exists(new GetIndexRequest(new String[]{name}), RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    public static void createIndex(RestHighLevelClient client, String name) {
        ElasticSearchMigration.createIndex(client, new CreateIndexRequest(name), 0);
    }

    public static void createIndex(RestHighLevelClient client, CreateIndexRequest createIndexRequest) {
        ElasticSearchMigration.createIndex(client, createIndexRequest, 0);
    }

    private static void createIndex(RestHighLevelClient client, CreateIndexRequest createIndexRequest, int retry) {
        ElasticSearchUtils.sleep((long)retry * 500L);
        try {
            ElasticSearchMigration.waitForHealthyCluster(client);
            client.indices().create(createIndexRequest, RequestOptions.DEFAULT);
            ElasticSearchMigration.waitForHealthyCluster(client);
        }
        catch (ElasticsearchStatusException e) {
            if (e.status().getStatus() == 400) {
                if (e.getMessage().contains("resource_already_exists_exception")) {
                    return;
                }
                if (e.status().getStatus() == 400 && retry < 5) {
                    ElasticSearchMigration.createIndex(client, createIndexRequest, retry + 1);
                }
                throw new StorageException("Retried 5 times to setup ElasticSearch Indices", e);
            }
            throw e;
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    void deleteIndex(RestHighLevelClient client, String name) throws IOException {
        try {
            ElasticSearchMigration.waitForHealthyCluster(client);
            client.indices().delete(new DeleteIndexRequest(name), RequestOptions.DEFAULT);
            ElasticSearchMigration.waitForHealthyCluster(client);
        }
        catch (ElasticsearchStatusException e) {
            if (e.status().getStatus() == 404) {
                return;
            }
            throw e;
        }
    }

    protected static Map<String, Object> mapping(BiConsumer<StringBuilder, Map<String, Object>> ... consumers) {
        HashMap<String, Object> jsonMap = new HashMap<String, Object>();
        HashMap properties = new HashMap();
        jsonMap.put("properties", properties);
        for (BiConsumer<StringBuilder, Map<String, Object>> consumer : consumers) {
            StringBuilder sb = new StringBuilder();
            HashMap fieldProperties = new HashMap();
            consumer.accept(sb, fieldProperties);
            properties.put(sb.toString(), fieldProperties);
        }
        return jsonMap;
    }
}

