/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.storage.nosql.mongo;

import com.mongodb.MongoWriteException;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bson.Document;
import org.jobrunr.JobRunrException;
import org.jobrunr.storage.StorageProviderUtils;
import org.jobrunr.storage.nosql.common.NoSqlDatabaseCreator;
import org.jobrunr.storage.nosql.common.migrations.NoSqlMigration;
import org.jobrunr.storage.nosql.mongo.MongoDBStorageProvider;
import org.jobrunr.storage.nosql.mongo.migrations.MongoMigration;

public class MongoDBCreator
extends NoSqlDatabaseCreator<MongoMigration> {
    private final MongoDatabase jobrunrDatabase;
    private final String collectionPrefix;
    private final MongoCollection<Document> migrationCollection;

    public MongoDBCreator(MongoClient mongoClient, String dbName) {
        this(mongoClient, dbName, null);
    }

    public MongoDBCreator(MongoClient mongoClient, String dbName, String collectionPrefix) {
        super(MongoDBStorageProvider.class);
        this.jobrunrDatabase = mongoClient.getDatabase(dbName);
        this.collectionPrefix = collectionPrefix;
        this.migrationCollection = this.jobrunrDatabase.getCollection(StorageProviderUtils.elementPrefixer(collectionPrefix, "migrations"));
    }

    public void validateCollections() {
        List<String> requiredCollectionNames = Arrays.asList("jobs", "recurring_jobs", "background_job_servers", "metadata");
        List availableCollectionNames = (List)this.jobrunrDatabase.listCollectionNames().into(new ArrayList());
        for (String requiredCollectionName : requiredCollectionNames) {
            if (availableCollectionNames.contains(StorageProviderUtils.elementPrefixer(this.collectionPrefix, requiredCollectionName))) continue;
            throw new JobRunrException("Not all required collections are available by JobRunr!");
        }
    }

    @Override
    protected boolean isNewMigration(NoSqlMigration noSqlMigration) {
        Document migration = (Document)this.migrationCollection.find(Filters.eq((String)MongoDBStorageProvider.toMongoId("id"), (Object)noSqlMigration.getClassName())).first();
        return migration == null;
    }

    @Override
    protected void runMigration(MongoMigration noSqlMigration) {
        noSqlMigration.runMigration(this.jobrunrDatabase, this.collectionPrefix);
    }

    @Override
    protected boolean markMigrationAsDone(NoSqlMigration noSqlMigration) {
        try {
            Document document = new Document();
            document.put(MongoDBStorageProvider.toMongoId("id"), (Object)noSqlMigration.getClassName());
            document.put("name", (Object)noSqlMigration.getClassName());
            document.put("date", (Object)Instant.now());
            return this.migrationCollection.insertOne((Object)document).wasAcknowledged();
        }
        catch (MongoWriteException e) {
            if (e.getError().getCode() == 11000) {
                return true;
            }
            throw e;
        }
    }
}

