/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.storage.nosql.mongo;

import com.mongodb.MongoClientSettings;
import com.mongodb.MongoException;
import com.mongodb.MongoWriteException;
import com.mongodb.ServerAddress;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Accumulators;
import com.mongodb.client.model.Aggregates;
import com.mongodb.client.model.BsonField;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Projections;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.model.Sorts;
import com.mongodb.client.model.UpdateOneModel;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.Updates;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.InsertOneResult;
import com.mongodb.client.result.UpdateResult;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.bson.Document;
import org.bson.UuidRepresentation;
import org.bson.codecs.Codec;
import org.bson.codecs.UuidCodec;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.jobrunr.JobRunrException;
import org.jobrunr.jobs.Job;
import org.jobrunr.jobs.JobDetails;
import org.jobrunr.jobs.JobListVersioner;
import org.jobrunr.jobs.JobVersioner;
import org.jobrunr.jobs.RecurringJob;
import org.jobrunr.jobs.mappers.JobMapper;
import org.jobrunr.jobs.states.StateName;
import org.jobrunr.storage.AbstractStorageProvider;
import org.jobrunr.storage.BackgroundJobServerStatus;
import org.jobrunr.storage.ConcurrentJobModificationException;
import org.jobrunr.storage.JobNotFoundException;
import org.jobrunr.storage.JobRunrMetadata;
import org.jobrunr.storage.JobStats;
import org.jobrunr.storage.Page;
import org.jobrunr.storage.PageRequest;
import org.jobrunr.storage.ServerTimedOutException;
import org.jobrunr.storage.StorageException;
import org.jobrunr.storage.StorageProviderUtils;
import org.jobrunr.storage.nosql.NoSqlStorageProvider;
import org.jobrunr.storage.nosql.mongo.MongoDBCreator;
import org.jobrunr.storage.nosql.mongo.MongoUtils;
import org.jobrunr.storage.nosql.mongo.mapper.BackgroundJobServerStatusDocumentMapper;
import org.jobrunr.storage.nosql.mongo.mapper.JobDocumentMapper;
import org.jobrunr.storage.nosql.mongo.mapper.MetadataDocumentMapper;
import org.jobrunr.storage.nosql.mongo.mapper.MongoDBPageRequestMapper;
import org.jobrunr.utils.JobUtils;
import org.jobrunr.utils.reflection.ReflectionUtils;
import org.jobrunr.utils.resilience.RateLimiter;

public class MongoDBStorageProvider
extends AbstractStorageProvider
implements NoSqlStorageProvider {
    public static final String DEFAULT_DB_NAME = "jobrunr";
    private static final MongoDBPageRequestMapper pageRequestMapper = new MongoDBPageRequestMapper();
    private final String databaseName;
    private final MongoClient mongoClient;
    private final MongoDatabase jobrunrDatabase;
    private final MongoCollection<Document> jobCollection;
    private final MongoCollection<Document> recurringJobCollection;
    private final MongoCollection<Document> backgroundJobServerCollection;
    private final MongoCollection<Document> metadataCollection;
    private final String collectionPrefix;
    private JobDocumentMapper jobDocumentMapper;
    private BackgroundJobServerStatusDocumentMapper backgroundJobServerStatusDocumentMapper;
    private MetadataDocumentMapper metadataDocumentMapper;

    public MongoDBStorageProvider(String hostName, int port) {
        this(MongoClients.create((MongoClientSettings)MongoClientSettings.builder().applyToClusterSettings(builder -> builder.hosts(Collections.singletonList(new ServerAddress(hostName, port)))).codecRegistry(CodecRegistries.fromRegistries((CodecRegistry[])new CodecRegistry[]{CodecRegistries.fromCodecs((Codec[])new Codec[]{new UuidCodec(UuidRepresentation.STANDARD)}), MongoClientSettings.getDefaultCodecRegistry()})).build()));
    }

    public MongoDBStorageProvider(MongoClient mongoClient) {
        this(mongoClient, RateLimiter.Builder.rateLimit().at1Request().per(RateLimiter.SECOND));
    }

    public MongoDBStorageProvider(MongoClient mongoClient, String dbName) {
        this(mongoClient, dbName, null, StorageProviderUtils.DatabaseOptions.CREATE, RateLimiter.Builder.rateLimit().at1Request().per(RateLimiter.SECOND));
    }

    public MongoDBStorageProvider(MongoClient mongoClient, String dbName, StorageProviderUtils.DatabaseOptions databaseOptions) {
        this(mongoClient, dbName, null, databaseOptions, RateLimiter.Builder.rateLimit().at1Request().per(RateLimiter.SECOND));
    }

    public MongoDBStorageProvider(MongoClient mongoClient, String dbName, String collectionPrefix) {
        this(mongoClient, dbName, collectionPrefix, StorageProviderUtils.DatabaseOptions.CREATE, RateLimiter.Builder.rateLimit().at1Request().per(RateLimiter.SECOND));
    }

    public MongoDBStorageProvider(MongoClient mongoClient, String dbName, String collectionPrefix, StorageProviderUtils.DatabaseOptions databaseOptions) {
        this(mongoClient, dbName, collectionPrefix, databaseOptions, RateLimiter.Builder.rateLimit().at1Request().per(RateLimiter.SECOND));
    }

    public MongoDBStorageProvider(MongoClient mongoClient, RateLimiter changeListenerNotificationRateLimit) {
        this(mongoClient, null, null, StorageProviderUtils.DatabaseOptions.CREATE, changeListenerNotificationRateLimit);
    }

    public MongoDBStorageProvider(MongoClient mongoClient, StorageProviderUtils.DatabaseOptions databaseOptions, RateLimiter changeListenerNotificationRateLimit) {
        this(mongoClient, null, null, databaseOptions, changeListenerNotificationRateLimit);
    }

    public MongoDBStorageProvider(MongoClient mongoClient, String dbName, String collectionPrefix, StorageProviderUtils.DatabaseOptions databaseOptions, RateLimiter changeListenerNotificationRateLimit) {
        super(changeListenerNotificationRateLimit);
        this.validateMongoClient(mongoClient);
        this.databaseName = Optional.ofNullable(dbName).orElse(DEFAULT_DB_NAME);
        this.collectionPrefix = collectionPrefix;
        this.mongoClient = mongoClient;
        this.setUpStorageProvider(databaseOptions);
        this.jobrunrDatabase = mongoClient.getDatabase(this.databaseName);
        this.jobCollection = this.jobrunrDatabase.getCollection(StorageProviderUtils.elementPrefixer(collectionPrefix, "jobs"), Document.class);
        this.recurringJobCollection = this.jobrunrDatabase.getCollection(StorageProviderUtils.elementPrefixer(collectionPrefix, "recurring_jobs"), Document.class);
        this.backgroundJobServerCollection = this.jobrunrDatabase.getCollection(StorageProviderUtils.elementPrefixer(collectionPrefix, "background_job_servers"), Document.class);
        this.metadataCollection = this.jobrunrDatabase.getCollection(StorageProviderUtils.elementPrefixer(collectionPrefix, "metadata"), Document.class);
    }

    @Override
    public void setJobMapper(JobMapper jobMapper) {
        this.jobDocumentMapper = new JobDocumentMapper(jobMapper);
        this.backgroundJobServerStatusDocumentMapper = new BackgroundJobServerStatusDocumentMapper();
        this.metadataDocumentMapper = new MetadataDocumentMapper();
    }

    @Override
    public void setUpStorageProvider(StorageProviderUtils.DatabaseOptions databaseOptions) {
        if (StorageProviderUtils.DatabaseOptions.CREATE == databaseOptions) {
            this.runMigrations(this.mongoClient, this.databaseName, this.collectionPrefix);
        } else {
            this.validateTables(this.mongoClient, this.databaseName, this.collectionPrefix);
        }
    }

    @Override
    public void announceBackgroundJobServer(BackgroundJobServerStatus serverStatus) {
        InsertOneResult result = this.backgroundJobServerCollection.insertOne((Object)this.backgroundJobServerStatusDocumentMapper.toInsertDocument(serverStatus));
        if (!result.wasAcknowledged()) {
            throw new StorageException("Unable to announce BackgroundJobServer.");
        }
    }

    @Override
    public boolean signalBackgroundJobServerAlive(BackgroundJobServerStatus serverStatus) {
        UpdateResult updateResult = this.backgroundJobServerCollection.updateOne(Filters.eq((String)MongoDBStorageProvider.toMongoId("id"), (Object)serverStatus.getId()), (Bson)this.backgroundJobServerStatusDocumentMapper.toUpdateDocument(serverStatus));
        if (updateResult.getModifiedCount() < 1L) {
            throw new ServerTimedOutException(serverStatus, new StorageException("BackgroundJobServer with id " + serverStatus.getId() + " was not found"));
        }
        Document document = (Document)this.backgroundJobServerCollection.find(Filters.eq((String)MongoDBStorageProvider.toMongoId("id"), (Object)serverStatus.getId())).projection(Projections.include((String[])new String[]{"running"})).first();
        return document != null && document.getBoolean((Object)"running") != false;
    }

    @Override
    public void signalBackgroundJobServerStopped(BackgroundJobServerStatus serverStatus) {
        this.backgroundJobServerCollection.deleteOne(Filters.eq((String)MongoDBStorageProvider.toMongoId("id"), (Object)serverStatus.getId()));
    }

    @Override
    public List<BackgroundJobServerStatus> getBackgroundJobServers() {
        return (List)this.backgroundJobServerCollection.find().sort(Sorts.ascending((String[])new String[]{"firstHeartbeat"})).map(this.backgroundJobServerStatusDocumentMapper::toBackgroundJobServerStatus).into(new ArrayList());
    }

    @Override
    public UUID getLongestRunningBackgroundJobServerId() {
        return (UUID)this.backgroundJobServerCollection.find().sort(Sorts.ascending((String[])new String[]{"firstHeartbeat"})).projection(Projections.include((String[])new String[]{MongoDBStorageProvider.toMongoId("id")})).map(MongoUtils::getIdAsUUID).first();
    }

    @Override
    public int removeTimedOutBackgroundJobServers(Instant heartbeatOlderThan) {
        DeleteResult deleteResult = this.backgroundJobServerCollection.deleteMany(Filters.lt((String)"lastHeartbeat", (Object)heartbeatOlderThan));
        return (int)deleteResult.getDeletedCount();
    }

    @Override
    public void saveMetadata(JobRunrMetadata metadata) {
        this.metadataCollection.updateOne(Filters.eq((String)MongoDBStorageProvider.toMongoId("id"), (Object)metadata.getId()), (Bson)this.metadataDocumentMapper.toUpdateDocument(metadata), new UpdateOptions().upsert(true));
        this.notifyMetadataChangeListeners();
    }

    @Override
    public List<JobRunrMetadata> getMetadata(String name) {
        return (List)this.metadataCollection.find(Filters.eq((String)"name", (Object)name)).map(this.metadataDocumentMapper::toJobRunrMetadata).into(new ArrayList());
    }

    @Override
    public JobRunrMetadata getMetadata(String name, String owner) {
        Document document = (Document)this.metadataCollection.find(Filters.eq((String)MongoDBStorageProvider.toMongoId("id"), (Object)JobRunrMetadata.toId(name, owner))).first();
        return this.metadataDocumentMapper.toJobRunrMetadata(document);
    }

    @Override
    public void deleteMetadata(String name) {
        DeleteResult deleteResult = this.metadataCollection.deleteMany(Filters.eq((String)"name", (Object)name));
        long deletedCount = deleteResult.getDeletedCount();
        this.notifyMetadataChangeListeners(deletedCount > 0L);
    }

    @Override
    public Job save(Job job) {
        try (JobVersioner jobVersioner = new JobVersioner(job);){
            if (jobVersioner.isNewJob()) {
                this.jobCollection.insertOne((Object)this.jobDocumentMapper.toInsertDocument(job));
            } else {
                UpdateOneModel<Document> updateModel = this.jobDocumentMapper.toUpdateOneModel(job);
                UpdateResult updateResult = this.jobCollection.updateOne(updateModel.getFilter(), updateModel.getUpdate());
                if (updateResult.getModifiedCount() < 1L) {
                    throw new ConcurrentJobModificationException(job);
                }
            }
            jobVersioner.commitVersion();
        }
        catch (MongoWriteException e) {
            if (e.getError().getCode() == 11000) {
                throw new ConcurrentJobModificationException(job);
            }
            throw new StorageException(e);
        }
        catch (MongoException e) {
            throw new StorageException(e);
        }
        this.notifyJobStatsOnChangeListeners();
        return job;
    }

    @Override
    public int deletePermanently(UUID id) {
        DeleteResult result = this.jobCollection.deleteOne(Filters.eq((String)MongoDBStorageProvider.toMongoId("id"), (Object)id));
        int deletedCount = (int)result.getDeletedCount();
        this.notifyJobStatsOnChangeListenersIf(deletedCount > 0);
        return deletedCount;
    }

    @Override
    public Job getJobById(UUID id) {
        Document document = (Document)this.jobCollection.find(Filters.eq((String)MongoDBStorageProvider.toMongoId("id"), (Object)id)).projection(Projections.include((String[])new String[]{"jobAsJson"})).first();
        if (document != null) {
            return this.jobDocumentMapper.toJob(document);
        }
        throw new JobNotFoundException(id);
    }

    @Override
    public List<Job> save(List<Job> jobs) {
        try (JobListVersioner jobListVersioner = new JobListVersioner(jobs);){
            if (jobListVersioner.areNewJobs()) {
                List jobsToInsert = jobs.stream().map(job -> this.jobDocumentMapper.toInsertDocument((Job)job)).collect(Collectors.toList());
                this.jobCollection.insertMany(jobsToInsert);
            } else {
                List jobsToUpdate = jobs.stream().map(job -> this.jobDocumentMapper.toUpdateOneModel((Job)job)).collect(Collectors.toList());
                BulkWriteResult bulkWriteResult = this.jobCollection.bulkWrite(jobsToUpdate);
                if (bulkWriteResult.getModifiedCount() != jobs.size()) {
                    HashMap mongoDbDocuments = new HashMap();
                    this.jobCollection.find(Filters.in((String)MongoDBStorageProvider.toMongoId("id"), (Iterable)jobs.stream().map(Job::getId).collect(Collectors.toList()))).projection(Projections.include((String[])new String[]{"jobAsJson"})).map(this.jobDocumentMapper::toJob).forEach(job -> mongoDbDocuments.put(job.getId(), job));
                    List<Job> concurrentModifiedJobs = jobs.stream().filter(job -> !job.getUpdatedAt().equals(((Job)mongoDbDocuments.get(job.getId())).getUpdatedAt())).collect(Collectors.toList());
                    jobListVersioner.rollbackVersions(concurrentModifiedJobs);
                    throw new ConcurrentJobModificationException(concurrentModifiedJobs);
                }
            }
            jobListVersioner.commitVersions();
        }
        catch (MongoException e) {
            throw new StorageException(e);
        }
        this.notifyJobStatsOnChangeListenersIf(!jobs.isEmpty());
        return jobs;
    }

    @Override
    public List<Job> getJobs(StateName state, Instant updatedBefore, PageRequest pageRequest) {
        return this.findJobs(Filters.and((Bson[])new Bson[]{Filters.eq((String)"state", (Object)state.name()), Filters.lt((String)"updatedAt", (Object)this.toMicroSeconds(updatedBefore))}), pageRequest);
    }

    @Override
    public List<Job> getScheduledJobs(Instant scheduledBefore, PageRequest pageRequest) {
        return this.findJobs(Filters.and((Bson[])new Bson[]{Filters.eq((String)"state", (Object)StateName.SCHEDULED.name()), Filters.lt((String)"scheduledAt", (Object)this.toMicroSeconds(scheduledBefore))}), pageRequest);
    }

    @Override
    public List<Job> getJobs(StateName state, PageRequest pageRequest) {
        return this.findJobs(Filters.eq((String)"state", (Object)state.name()), pageRequest);
    }

    @Override
    public Page<Job> getJobPage(StateName state, PageRequest pageRequest) {
        return this.getJobPage(Filters.eq((String)"state", (Object)state.name()), pageRequest);
    }

    @Override
    public int deleteJobsPermanently(StateName state, Instant updatedBefore) {
        DeleteResult deleteResult = this.jobCollection.deleteMany(Filters.and((Bson[])new Bson[]{Filters.eq((String)"state", (Object)state.name()), Filters.lt((String)"createdAt", (Object)this.toMicroSeconds(updatedBefore))}));
        long deletedCount = deleteResult.getDeletedCount();
        this.notifyJobStatsOnChangeListenersIf(deletedCount > 0L);
        return (int)deletedCount;
    }

    @Override
    public Set<String> getDistinctJobSignatures(StateName ... states) {
        return (Set)this.jobCollection.distinct("jobSignature", Filters.in((String)"state", (Iterable)Arrays.stream(states).map(Enum::name).collect(Collectors.toSet())), String.class).into(new HashSet());
    }

    @Override
    public boolean exists(JobDetails jobDetails, StateName ... states) {
        return this.jobCollection.countDocuments(Filters.and((Bson[])new Bson[]{Filters.in((String)"state", (Iterable)Arrays.stream(states).map(Enum::name).collect(Collectors.toSet())), Filters.eq((String)"jobSignature", (Object)JobUtils.getJobSignature(jobDetails))})) > 0L;
    }

    @Override
    public boolean recurringJobExists(String recurringJobId, StateName ... states) {
        return this.jobCollection.countDocuments(Filters.and((Bson[])new Bson[]{Filters.in((String)"state", (Iterable)Arrays.stream(states).map(Enum::name).collect(Collectors.toSet())), Filters.eq((String)"recurringJobId", (Object)recurringJobId)})) > 0L;
    }

    @Override
    public RecurringJob saveRecurringJob(RecurringJob recurringJob) {
        this.recurringJobCollection.replaceOne(Filters.eq((String)MongoDBStorageProvider.toMongoId("id"), (Object)recurringJob.getId()), (Object)this.jobDocumentMapper.toInsertDocument(recurringJob), new ReplaceOptions().upsert(true));
        return recurringJob;
    }

    @Override
    public List<RecurringJob> getRecurringJobs() {
        return (List)this.recurringJobCollection.find().map(this.jobDocumentMapper::toRecurringJob).into(new ArrayList());
    }

    @Override
    public long countRecurringJobs() {
        return this.recurringJobCollection.countDocuments();
    }

    @Override
    public int deleteRecurringJob(String id) {
        DeleteResult deleteResult = this.recurringJobCollection.deleteOne(Filters.eq((String)MongoDBStorageProvider.toMongoId("id"), (Object)id));
        return (int)deleteResult.getDeletedCount();
    }

    @Override
    public JobStats getJobStats() {
        Instant instant = Instant.now();
        Document succeededJobStats = (Document)this.metadataCollection.find(Filters.eq((String)MongoDBStorageProvider.toMongoId("id"), (Object)"succeeded-jobs-counter-cluster")).first();
        long allTimeSucceededCount = succeededJobStats != null ? ((Number)succeededJobStats.get((Object)"value")).longValue() : 0L;
        List aggregates = (List)this.jobCollection.aggregate(Arrays.asList(Aggregates.match((Bson)Filters.ne((String)"state", null)), Aggregates.group((Object)"$state", (BsonField[])new BsonField[]{Accumulators.sum((String)"state", (Object)1)}), Aggregates.limit((int)10))).into(new ArrayList());
        Long scheduledCount = this.getCount(StateName.SCHEDULED, aggregates);
        Long enqueuedCount = this.getCount(StateName.ENQUEUED, aggregates);
        Long processingCount = this.getCount(StateName.PROCESSING, aggregates);
        Long succeededCount = this.getCount(StateName.SUCCEEDED, aggregates);
        Long failedCount = this.getCount(StateName.FAILED, aggregates);
        Long deletedCount = this.getCount(StateName.DELETED, aggregates);
        long total = scheduledCount + enqueuedCount + processingCount + succeededCount + failedCount;
        int recurringJobCount = (int)this.recurringJobCollection.countDocuments();
        int backgroundJobServerCount = (int)this.backgroundJobServerCollection.countDocuments();
        return new JobStats(instant, total, scheduledCount, enqueuedCount, processingCount, failedCount, succeededCount, allTimeSucceededCount, deletedCount, recurringJobCount, backgroundJobServerCount);
    }

    @Override
    public void publishTotalAmountOfSucceededJobs(int amount) {
        this.metadataCollection.updateOne(Filters.eq((String)MongoDBStorageProvider.toMongoId("id"), (Object)"succeeded-jobs-counter-cluster"), Updates.inc((String)"value", (Number)amount), new UpdateOptions().upsert(true));
    }

    private long toMicroSeconds(Instant instant) {
        return ChronoUnit.MICROS.between(Instant.EPOCH, instant);
    }

    private Long getCount(StateName stateName, List<Document> aggregates) {
        Predicate<Document> statePredicate = document -> stateName.name().equals(document.get((Object)MongoDBStorageProvider.toMongoId("id")));
        BiFunction<Optional, Integer, Integer> count = (document, defaultValue) -> document.map(doc -> doc.getInteger((Object)"state")).orElse((Integer)defaultValue);
        long aggregateCount = count.apply(aggregates.stream().filter(statePredicate).findFirst(), 0).intValue();
        return aggregateCount;
    }

    public static String toMongoId(String id) {
        return "_" + id;
    }

    private Page<Job> getJobPage(Bson query, PageRequest pageRequest) {
        long count = this.jobCollection.countDocuments(query);
        if (count > 0L) {
            List<Job> jobs = this.findJobs(query, pageRequest);
            return new Page<Job>(count, jobs, pageRequest);
        }
        return new Page<Job>(0L, new ArrayList(), pageRequest);
    }

    private List<Job> findJobs(Bson query, PageRequest pageRequest) {
        return (List)this.jobCollection.find(query).sort(pageRequestMapper.map(pageRequest)).skip((int)pageRequest.getOffset()).limit(pageRequest.getLimit()).projection(Projections.include((String[])new String[]{"jobAsJson"})).map(this.jobDocumentMapper::toJob).into(new ArrayList());
    }

    private void validateMongoClient(MongoClient mongoClient) {
        Optional<Method> codecRegistryGetter = ReflectionUtils.findMethod(mongoClient, "getCodecRegistry", new Class[0]);
        if (codecRegistryGetter.isPresent()) {
            try {
                CodecRegistry codecRegistry = (CodecRegistry)codecRegistryGetter.get().invoke((Object)mongoClient, new Object[0]);
                UuidCodec uuidCodec = (UuidCodec)codecRegistry.get(UUID.class);
                if (UuidRepresentation.UNSPECIFIED == uuidCodec.getUuidRepresentation()) {
                    throw new StorageException("\nSince release 4.0.0 of the MongoDB Java Driver, the default BSON representation of java.util.UUID values has changed from JAVA_LEGACY to UNSPECIFIED.\nApplications that store or retrieve UUID values must explicitly specify which representation to use, via the uuidRepresentation property of MongoClientSettings.\nThe good news is that JobRunr works both with the STANDARD as the JAVA_LEGACY uuidRepresentation. Please choose the one most appropriate for your application.");
                }
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw JobRunrException.shouldNotHappenException(e);
            }
        }
    }

    private void runMigrations(MongoClient mongoClient, String dbName, String collectionPrefix) {
        new MongoDBCreator(mongoClient, dbName, collectionPrefix).runMigrations();
    }

    private void validateTables(MongoClient mongoClient, String dbName, String collectionPrefix) {
        new MongoDBCreator(mongoClient, dbName, collectionPrefix).validateCollections();
    }

    private void explainQuery(Bson query) {
        Document explainDocument = new Document();
        explainDocument.put("find", (Object)"jobs");
        explainDocument.put("filter", (Object)query);
        Document command = new Document();
        command.put("explain", (Object)explainDocument);
        Document document = this.jobrunrDatabase.runCommand((Bson)command);
        System.out.println(document.toJson());
    }
}

