/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.storage.nosql.redis.migrations;

import java.io.IOException;
import org.jobrunr.jobs.states.StateName;
import org.jobrunr.storage.nosql.redis.RedisUtilities;
import org.jobrunr.storage.nosql.redis.migrations.JedisRedisMigration;
import org.jobrunr.utils.StringUtils;
import redis.clients.jedis.Jedis;

public class M001_JedisRemoveJobStatsAndUseMetadata
extends JedisRedisMigration {
    @Override
    public void runMigration(Jedis jedis, String keyPrefix) throws IOException {
        if (jedis.hget(RedisUtilities.metadataKey(keyPrefix, "succeeded-jobs-counter-cluster"), "value") != null) {
            return;
        }
        String succeededCounterResponse = jedis.get(RedisUtilities.jobCounterKey(StateName.SUCCEEDED));
        if (StringUtils.isNotNullOrEmpty(succeededCounterResponse)) {
            jedis.hincrBy(RedisUtilities.metadataKey(keyPrefix, "succeeded-jobs-counter-cluster"), "value", Long.parseLong(succeededCounterResponse));
            jedis.del(RedisUtilities.jobCounterKey(StateName.SUCCEEDED));
        } else {
            jedis.hset(RedisUtilities.metadataKey(keyPrefix, "succeeded-jobs-counter-cluster"), "value", "0");
        }
    }
}

