/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.storage.sql.common;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jobrunr.storage.sql.SqlStorageProvider;
import org.jobrunr.storage.sql.common.DatabaseCreator;
import org.jobrunr.storage.sql.common.migrations.DefaultSqlMigrationProvider;
import org.jobrunr.storage.sql.common.migrations.RunningOnJava11OrLowerWithinFatJarSqlMigrationProvider;
import org.jobrunr.storage.sql.common.migrations.SqlMigration;
import org.jobrunr.storage.sql.common.migrations.SqlMigrationProvider;
import org.jobrunr.utils.RuntimeUtils;
import org.jobrunr.utils.annotations.Because;

@Because(value="https://github.com/jobrunr/jobrunr/issues/83")
class DatabaseMigrationsProvider {
    private final Class<? extends SqlStorageProvider> sqlStorageProviderClass;

    public DatabaseMigrationsProvider(Class<? extends SqlStorageProvider> sqlStorageProviderClass) {
        this.sqlStorageProviderClass = sqlStorageProviderClass;
    }

    public Stream<SqlMigration> getMigrations() {
        SqlMigrationProvider migrationProvider = this.getMigrationProvider();
        Map<String, SqlMigration> commonMigrations = this.getCommonMigrations(migrationProvider).stream().collect(Collectors.toMap(SqlMigration::getFileName, m -> m));
        Map<String, SqlMigration> databaseSpecificMigrations = this.getDatabaseSpecificMigrations(migrationProvider).stream().collect(Collectors.toMap(SqlMigration::getFileName, p -> p));
        HashMap<String, SqlMigration> actualMigrations = new HashMap<String, SqlMigration>(commonMigrations);
        actualMigrations.putAll(databaseSpecificMigrations);
        return actualMigrations.values().stream();
    }

    private SqlMigrationProvider getMigrationProvider() {
        if (RuntimeUtils.getJvmVersion() < 12 && RuntimeUtils.isRunningFromNestedJar()) {
            return new RunningOnJava11OrLowerWithinFatJarSqlMigrationProvider();
        }
        return new DefaultSqlMigrationProvider();
    }

    protected List<SqlMigration> getCommonMigrations(SqlMigrationProvider migrationProvider) {
        return migrationProvider.getMigrations(DatabaseCreator.class);
    }

    protected List<SqlMigration> getDatabaseSpecificMigrations(SqlMigrationProvider migrationProvider) {
        if (this.sqlStorageProviderClass != null) {
            return migrationProvider.getMigrations(this.sqlStorageProviderClass);
        }
        return Collections.emptyList();
    }
}

