/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.storage.sql.common;

import java.util.HashSet;
import java.util.Set;
import org.jobrunr.storage.PageRequest;

public class SqlPageRequestMapper {
    private static final Set<String> allowedSortColumns = new HashSet<String>();

    public String map(PageRequest pageRequest) {
        String[] sortOns;
        StringBuilder result = new StringBuilder();
        for (String sortOn : sortOns = pageRequest.getOrder().split(",")) {
            String[] sortAndOrder = sortOn.split(":");
            if (!allowedSortColumns.contains(sortAndOrder[0])) continue;
            String sortField = sortAndOrder[0];
            PageRequest.Order order = PageRequest.Order.ASC;
            if (sortAndOrder.length > 1) {
                order = PageRequest.Order.valueOf(sortAndOrder[1].toUpperCase());
            }
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append(sortField).append(" ").append(order.name());
        }
        return result.toString();
    }

    static {
        allowedSortColumns.add("createdAt");
        allowedSortColumns.add("updatedAt");
    }
}

