/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.storage.sql.common.db;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.jobrunr.utils.reflection.ReflectionUtils;

public class SqlResultSet {
    private final Set<String> columns;
    private final Map<String, Object> values;

    public SqlResultSet(ResultSet rs) throws SQLException {
        this.columns = this.getColumns(rs);
        this.values = this.initValues(rs, this.columns);
    }

    private Map<String, Object> initValues(ResultSet rs, Set<String> columns) throws SQLException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String columnName : columns) {
            result.put(columnName, rs.getObject(columnName));
        }
        return result;
    }

    private Object val(String name) {
        return this.values.get(name.toLowerCase());
    }

    public boolean asBoolean(String name) {
        return ReflectionUtils.autobox(this.val(name), Boolean.class);
    }

    public String asString(String name) {
        return ReflectionUtils.autobox(this.val(name), String.class);
    }

    public int asInt(String name) {
        return ReflectionUtils.autobox(this.val(name), Integer.class);
    }

    public UUID asUUID(String name) {
        return ReflectionUtils.autobox(this.val(name), UUID.class);
    }

    public long asLong(String name) {
        return ReflectionUtils.autobox(this.val(name), Long.class);
    }

    public Instant asInstant(String name) {
        return ReflectionUtils.autobox(this.val(name), Instant.class);
    }

    public Duration asDuration(String name) {
        return ReflectionUtils.autobox(this.val(name), Duration.class);
    }

    public float asFloat(String name) {
        return ReflectionUtils.autobox(this.val(name), Float.class).floatValue();
    }

    public double asDouble(String name) {
        return ReflectionUtils.autobox(this.val(name), Double.class);
    }

    public BigDecimal asBigDecimal(String name) {
        return ReflectionUtils.autobox(this.val(name), BigDecimal.class);
    }

    private Set<String> getColumns(ResultSet resultSet) throws SQLException {
        HashSet<String> result = new HashSet<String>();
        ResultSetMetaData metaData = resultSet.getMetaData();
        for (int i = 1; i <= metaData.getColumnCount(); ++i) {
            result.add(metaData.getColumnName(i).toLowerCase());
        }
        return result;
    }
}

