/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.storage.sql.common.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Spliterator;
import java.util.function.Consumer;
import org.jobrunr.storage.StorageException;
import org.jobrunr.storage.sql.common.db.SqlResultSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlSpliterator
implements Spliterator<SqlResultSet>,
AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(SqlSpliterator.class);
    private final Connection connection;
    private final String sqlStatement;
    private final Consumer<PreparedStatement> paramsSetter;
    private PreparedStatement ps;
    private ResultSet rs;
    private boolean hasMore;

    public SqlSpliterator(Connection connection, String sqlStatement, Consumer<PreparedStatement> paramsSetter) {
        this.connection = connection;
        this.sqlStatement = sqlStatement;
        this.paramsSetter = paramsSetter;
    }

    @Override
    public boolean tryAdvance(Consumer<? super SqlResultSet> consumer) {
        try {
            if (this.ps == null) {
                this.init();
                this.hasMore = this.rs.next();
                if (!this.hasMore) {
                    this.close();
                }
            }
            if (!this.hasMore) {
                return false;
            }
            consumer.accept(new SqlResultSet(this.rs));
            this.hasMore = this.rs.next();
            if (!this.hasMore) {
                this.close();
            }
            return this.hasMore;
        }
        catch (SQLException e) {
            this.close();
            throw new StorageException(e);
        }
    }

    private void init() {
        try {
            this.ps = this.connection.prepareStatement(this.sqlStatement, 1003, 1007);
            this.ps.setFetchSize(100);
            this.paramsSetter.accept(this.ps);
            this.rs = this.ps.executeQuery();
        }
        catch (SQLException e) {
            this.close();
            throw new StorageException(e);
        }
    }

    @Override
    public void close() {
        this.close(this.rs);
        this.close(this.ps);
    }

    private void close(AutoCloseable closeable) {
        block2: {
            try {
                closeable.close();
            }
            catch (Exception e) {
                if (!(closeable instanceof Connection)) break block2;
                LOGGER.error("Could not close connection", (Throwable)e);
            }
        }
    }

    @Override
    public Spliterator<SqlResultSet> trySplit() {
        return null;
    }

    @Override
    public long estimateSize() {
        return Long.MAX_VALUE;
    }

    @Override
    public int characteristics() {
        return 0;
    }
}

