/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CollectionUtils {
    private CollectionUtils() {
    }

    public static <T> boolean isNotNullOrEmpty(Collection<T> collection) {
        return !CollectionUtils.isNullOrEmpty(collection);
    }

    public static <T> boolean isNullOrEmpty(Collection<T> collection) {
        if (collection == null) {
            return true;
        }
        return collection.isEmpty();
    }

    public static <T> boolean isNotNullOrEmpty(T[] someArray) {
        return !CollectionUtils.isNullOrEmpty(someArray);
    }

    public static <T> boolean isNullOrEmpty(T[] someArray) {
        if (someArray == null) {
            return true;
        }
        return someArray.length < 1;
    }

    public static <T> List<T> asList(T[] array, T ... params) {
        ArrayList<T> result = new ArrayList<T>();
        result.addAll(Arrays.asList(array));
        result.addAll(Arrays.asList(params));
        return result;
    }

    public static <T> ArrayList<T> asArrayList(Collection<T> existingCollection) {
        ArrayList<T> result = new ArrayList<T>();
        if (existingCollection != null) {
            result.addAll(existingCollection);
        }
        return result;
    }

    public static <T> Set<T> asSet(T ... items) {
        return Stream.of(items).collect(Collectors.toSet());
    }

    public static <T> Set<T> asSet(Collection<T> ... existingCollections) {
        HashSet<T> result = new HashSet<T>();
        for (Collection<T> existingCollection : existingCollections) {
            result.addAll(existingCollection);
        }
        return result;
    }

    public static <K, V> Map<K, V> mapOf(K key1, V value1) {
        HashMap<K, V> result = new HashMap<K, V>();
        result.put(key1, value1);
        return result;
    }

    public static <K, V> Map<K, V> mapOf(K key1, V value1, K key2, V value2) {
        Map<K, V> result = CollectionUtils.mapOf(key1, value1);
        result.put(key2, value2);
        return result;
    }
}

