/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.utils.diagnostics;

import java.io.IOException;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.jobrunr.jobs.details.JobDetailsGeneratorUtils;
import org.jobrunr.utils.diagnostics.DiagnosticsBulletedLine;
import org.jobrunr.utils.diagnostics.DiagnosticsException;
import org.jobrunr.utils.diagnostics.DiagnosticsItem;
import org.jobrunr.utils.diagnostics.DiagnosticsLine;
import org.jobrunr.utils.diagnostics.DiagnosticsTitle;
import org.jobrunr.utils.io.IOUtils;

public class DiagnosticsBuilder {
    private final List<DiagnosticsItem> diagnosticsItems = new ArrayList<DiagnosticsItem>();

    private DiagnosticsBuilder() {
    }

    public static DiagnosticsBuilder diagnostics() {
        return new DiagnosticsBuilder();
    }

    public DiagnosticsBuilder withTitle(String title) {
        this.diagnosticsItems.add(new DiagnosticsTitle(title));
        return this;
    }

    public DiagnosticsBuilder withSubTitle(String title) {
        this.diagnosticsItems.add(new DiagnosticsTitle(1, title));
        return this;
    }

    public DiagnosticsBuilder withLine(String line) {
        this.diagnosticsItems.add(new DiagnosticsLine(line));
        return this;
    }

    public DiagnosticsBuilder withIndentedLine(String line) {
        this.diagnosticsItems.add(new DiagnosticsLine(1, line));
        return this;
    }

    public DiagnosticsBuilder withIndentedLine(int amountOfIndentation, String line) {
        this.diagnosticsItems.add(new DiagnosticsLine(amountOfIndentation, line));
        return this;
    }

    public DiagnosticsBuilder withBulletedLine(String line) {
        this.diagnosticsItems.add(new DiagnosticsBulletedLine(line));
        return this;
    }

    public DiagnosticsBuilder withBulletedLine(String key, String value) {
        this.diagnosticsItems.add(new DiagnosticsBulletedLine(key, value));
        return this;
    }

    public DiagnosticsBuilder withIndentedBulletedLine(String key, String value) {
        this.diagnosticsItems.add(new DiagnosticsBulletedLine(1, key, value));
        return this;
    }

    public DiagnosticsBuilder withBulletedTextBlock(String key, String textBlock) {
        this.diagnosticsItems.add(new DiagnosticsBulletedLine(key, "\n" + textBlock));
        return this;
    }

    public DiagnosticsBuilder withEmptyLine() {
        this.diagnosticsItems.add(new DiagnosticsLine(""));
        return this;
    }

    public <T> DiagnosticsBuilder with(List<T> items, BiConsumer<T, DiagnosticsBuilder> consumer) {
        if (items.isEmpty()) {
            this.withLine("No items available");
        } else {
            items.forEach(item -> consumer.accept(item, this));
        }
        return this;
    }

    public DiagnosticsBuilder withObject(Object object) {
        return this.withObject("object", object);
    }

    public DiagnosticsBuilder withObject(String key, Object object) {
        return this.withBulletedLine(key, object.toString() + "(" + object.getClass().getName() + ")");
    }

    public DiagnosticsBuilder withParameterTypes(Class<?>[] paramTypes) {
        return this.withBulletedLine("parameterTypes", Arrays.stream(paramTypes).map(Class::getName).collect(Collectors.joining(", ")));
    }

    public DiagnosticsBuilder withParameters(Object[] parameters) {
        return this.withBulletedLine("parameters", Arrays.stream(parameters).map(o -> o.toString() + "(" + o.getClass().getName() + ")").collect(Collectors.joining(", ")));
    }

    public DiagnosticsBuilder withException(Exception exception) {
        this.diagnosticsItems.add(new DiagnosticsException(exception));
        return this;
    }

    public DiagnosticsBuilder withDiagnostics(int shiftTitle, DiagnosticsBuilder diagnostics) {
        List diagnosticsItems = diagnostics.diagnosticsItems.stream().map(item -> this.shiftDiagnosticsTitle(shiftTitle, (DiagnosticsItem)item)).collect(Collectors.toList());
        this.diagnosticsItems.addAll(diagnosticsItems);
        return this;
    }

    public String asMarkDown() {
        StringBuilder result = new StringBuilder();
        this.diagnosticsItems.forEach(diagnosticsItem -> result.append(diagnosticsItem.toMarkdown()));
        return result.toString();
    }

    public DiagnosticsBuilder withLambda(Object lambda) {
        String location = JobDetailsGeneratorUtils.getClassLocationOfLambda(lambda);
        URL resource = lambda.getClass().getResource(location);
        return this.withBulletedLine("lambda", lambda.toString()).withBulletedLine("lambda location", location).withBulletedTextBlock("class file", this.disassembleClassFromJava(resource.toExternalForm()));
    }

    String disassembleClassFromJava(String resourceFile) {
        try {
            ProcessBuilder pb = new ProcessBuilder("javap", "-c", resourceFile).redirectErrorStream(true);
            Process process = pb.start();
            StringWriter writer = new StringWriter();
            new Thread(() -> IOUtils.copyStreamNoException(process.getInputStream(), writer)).start();
            int exitValue = process.waitFor();
            String processOutput = writer.toString();
            return processOutput;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return "Unable to run javap command (" + e.getMessage() + ").";
        }
        catch (IOException e) {
            return "Unable to run javap command (" + e.getMessage() + ").";
        }
    }

    private DiagnosticsItem shiftDiagnosticsTitle(int amount, DiagnosticsItem diagnosticsItem) {
        if (diagnosticsItem instanceof DiagnosticsTitle) {
            return new DiagnosticsTitle(amount, (DiagnosticsTitle)diagnosticsItem);
        }
        return diagnosticsItem;
    }
}

