/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.utils.exceptions;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.function.Supplier;

public class Exceptions {
    public static boolean hasCause(Throwable t, Class<? extends Throwable> exceptionClass) {
        if (t.getClass().isAssignableFrom(exceptionClass)) {
            return true;
        }
        if (t.getCause() != null) {
            return Exceptions.hasCause(t.getCause(), exceptionClass);
        }
        return false;
    }

    public static String getStackTraceAsString(Throwable exception) {
        StringWriter sw = new StringWriter();
        exception.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T> T retryOnException(Supplier<T> supplier, int maxRetries) {
        int count = 0;
        while (true) {
            try {
                Thread.sleep(count * 20);
                return supplier.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                continue;
            }
            catch (RuntimeException e) {
                if (++count >= maxRetries) throw e;
                continue;
            }
            break;
        }
    }

    @FunctionalInterface
    public static interface ThrowingBiFunction<T, U, R> {
        public R apply(T var1, U var2) throws Exception;
    }

    @FunctionalInterface
    public static interface ThrowingFunction<T, R> {
        public R apply(T var1) throws Exception;
    }

    @FunctionalInterface
    public static interface ThrowingBiConsumer<T, U> {
        public void accept(T var1, U var2) throws Exception;
    }

    @FunctionalInterface
    public static interface ThrowingConsumer<T> {
        public void accept(T var1) throws Exception;
    }

    @FunctionalInterface
    public static interface ThrowingRunnable {
        public void run() throws Exception;
    }

    @FunctionalInterface
    public static interface ThrowingSupplier<T> {
        public T get() throws Exception;
    }
}

