/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.utils.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Writer;

public class IOUtils {
    private IOUtils() {
    }

    public static void copyStreamNoException(InputStream input, Writer output) {
        try {
            IOUtils.copyStream(input, output);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void copyStream(InputStream input, Writer output) throws IOException {
        try (InputStreamReader inputStreamReader = new InputStreamReader(input);){
            int bytesRead;
            char[] buffer = new char[1024];
            while ((bytesRead = inputStreamReader.read(buffer)) != -1) {
                output.write(buffer, 0, bytesRead);
            }
        }
    }

    public static void copyStream(InputStream input, OutputStream output) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[1024];
        while ((bytesRead = input.read(buffer)) != -1) {
            output.write(buffer, 0, bytesRead);
        }
    }
}

