/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.utils.mapper.jackson.modules;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import org.jobrunr.jobs.JobParameter;
import org.jobrunr.jobs.JobParameterNotDeserializableException;
import org.jobrunr.utils.mapper.JsonMapperUtils;
import org.jobrunr.utils.reflection.ReflectionUtils;

public class JobParameterDeserializer
extends StdDeserializer<JobParameter> {
    private final ObjectMapper objectMapper = new ObjectMapper();

    protected JobParameterDeserializer() {
        super(JobParameter.class);
    }

    public JobParameter deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        String className = node.get("className").asText();
        String actualClassName = node.has("actualClassName") ? node.get("actualClassName").asText() : null;
        JsonNode objectJsonNode = node.get("object");
        if (Path.class.getName().equals(className)) {
            return new JobParameter(className, (Object)Paths.get(objectJsonNode.asText().replace("file:", ""), new String[0]));
        }
        return this.getJobParameter(jsonParser, className, actualClassName, objectJsonNode);
    }

    private JobParameter getJobParameter(JsonParser jsonParser, String className, String actualClassName, JsonNode objectJsonNode) throws JsonProcessingException {
        try {
            Class valueType = ReflectionUtils.toClass(JobParameterDeserializer.getActualClassName(className, actualClassName));
            if (objectJsonNode.isArray() && !Collection.class.isAssignableFrom(valueType)) {
                JsonNode jsonNodeInArray = objectJsonNode.get(1);
                Object object = jsonParser.getCodec().treeToValue((TreeNode)jsonNodeInArray, valueType);
                return new JobParameter(className, object);
            }
            try {
                Object object = jsonParser.getCodec().treeToValue((TreeNode)objectJsonNode, valueType);
                return new JobParameter(className, object);
            }
            catch (MismatchedInputException e) {
                if (valueType.isEnum()) {
                    ArrayNode arrayNode = (ArrayNode)jsonParser.getCodec().createArrayNode();
                    arrayNode.add(valueType.getName());
                    arrayNode.add(objectJsonNode);
                    Object object = jsonParser.getCodec().treeToValue((TreeNode)arrayNode, valueType);
                    return new JobParameter(className, object);
                }
                Object object = this.objectMapper.treeToValue((TreeNode)objectJsonNode, valueType);
                return new JobParameter(className, object);
            }
        }
        catch (Exception e) {
            return new JobParameter(new JobParameterNotDeserializableException(JobParameterDeserializer.getActualClassName(className, actualClassName), e.getMessage()));
        }
    }

    public static String getActualClassName(String methodClassName, String actualClassName) {
        return JsonMapperUtils.getActualClassName(methodClassName, actualClassName, "sun.", "com.sun.");
    }
}

