/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.utils.mapper.jsonb;

import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.json.JsonObject;
import javax.json.JsonValue;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbBuilder;
import javax.json.bind.JsonbConfig;
import javax.json.bind.adapter.JsonbAdapter;
import javax.json.bind.config.PropertyVisibilityStrategy;
import javax.json.bind.serializer.JsonbDeserializer;
import javax.json.bind.serializer.JsonbSerializer;
import org.jobrunr.jobs.Job;
import org.jobrunr.jobs.JobDetails;
import org.jobrunr.jobs.states.JobState;
import org.jobrunr.utils.mapper.jsonb.FieldAccessStrategy;
import org.jobrunr.utils.mapper.jsonb.JobRunrJsonb;
import org.jobrunr.utils.mapper.jsonb.NullSafeJsonBuilder;
import org.jobrunr.utils.mapper.jsonb.adapters.JobDetailsAdapter;
import org.jobrunr.utils.mapper.jsonb.adapters.JobHistoryAdapter;
import org.jobrunr.utils.mapper.jsonb.adapters.JobMetadataAdapter;
import org.jobrunr.utils.mapper.jsonb.serializer.DurationTypeDeserializer;
import org.jobrunr.utils.mapper.jsonb.serializer.DurationTypeSerializer;
import org.jobrunr.utils.mapper.jsonb.serializer.FileTypeDeserializer;
import org.jobrunr.utils.mapper.jsonb.serializer.FileTypeSerializer;
import org.jobrunr.utils.mapper.jsonb.serializer.PathTypeDeserializer;
import org.jobrunr.utils.mapper.jsonb.serializer.PathTypeSerializer;

public class JobAdapter
implements JsonbAdapter<Job, JsonObject> {
    private final JobRunrJsonb jsonb;
    private final JobDetailsAdapter jobDetailsAdapter;
    private final JobHistoryAdapter jobHistoryAdapter;
    private final JobMetadataAdapter jobMetadataAdapter;

    public JobAdapter() {
        Jsonb jsonb = JsonbBuilder.create((JsonbConfig)new JsonbConfig().withNullValues(Boolean.valueOf(true)).withPropertyVisibilityStrategy((PropertyVisibilityStrategy)new FieldAccessStrategy()).withSerializers(new JsonbSerializer[]{new PathTypeSerializer(), new FileTypeSerializer(), new DurationTypeSerializer()}).withDeserializers(new JsonbDeserializer[]{new PathTypeDeserializer(), new FileTypeDeserializer(), new DurationTypeDeserializer()}));
        this.jsonb = new JobRunrJsonb(jsonb);
        this.jobDetailsAdapter = new JobDetailsAdapter(this.jsonb);
        this.jobHistoryAdapter = new JobHistoryAdapter(this.jsonb);
        this.jobMetadataAdapter = new JobMetadataAdapter(this.jsonb);
    }

    public JsonObject adaptToJson(Job job) throws Exception {
        NullSafeJsonBuilder builder = NullSafeJsonBuilder.nullSafeJsonObjectBuilder().add("id", job.getId()).add("jobName", job.getJobName()).add("jobSignature", job.getJobSignature()).add("version", job.getVersion()).add("metadata", (JsonValue)this.jobMetadataAdapter.adaptToJson(job.getMetadata())).add("jobDetails", (JsonValue)this.jobDetailsAdapter.adaptToJson(job.getJobDetails())).add("jobHistory", (JsonValue)this.jobHistoryAdapter.adaptToJson(job.getJobStates())).add("recurringJobId", (String)job.getRecurringJobId().orElse(null));
        if (job.getId() != null) {
            builder.add("id", job.getId().toString());
        } else {
            builder.addNull("id");
        }
        return builder.build();
    }

    public Job adaptFromJson(JsonObject jsonObject) throws Exception {
        UUID id = jsonObject.isNull("id") ? null : UUID.fromString(jsonObject.getString("id"));
        int version = jsonObject.getInt("version", 0);
        JobDetails jobDetails = this.jobDetailsAdapter.adaptFromJson(jsonObject.getJsonObject("jobDetails"));
        List<JobState> jobHistory = this.jobHistoryAdapter.adaptFromJson(jsonObject.getJsonArray("jobHistory"));
        ConcurrentHashMap<String, Object> jobMetadata = this.jobMetadataAdapter.adaptFromJson(jsonObject.getJsonObject("metadata"));
        Job job = new Job(id, version, jobDetails, jobHistory, jobMetadata);
        job.setJobName(jsonObject.getString("jobName"));
        job.setRecurringJobId(jsonObject.containsKey((Object)"recurringJobId") && !jsonObject.isNull("recurringJobId") ? jsonObject.getString("recurringJobId") : null);
        return job;
    }
}

