/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.utils.mapper.jsonb;

import javax.json.JsonObject;
import javax.json.JsonValue;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbBuilder;
import javax.json.bind.JsonbConfig;
import javax.json.bind.adapter.JsonbAdapter;
import javax.json.bind.config.PropertyVisibilityStrategy;
import javax.json.bind.serializer.JsonbDeserializer;
import javax.json.bind.serializer.JsonbSerializer;
import org.jobrunr.dashboard.ui.model.RecurringJobUIModel;
import org.jobrunr.jobs.RecurringJob;
import org.jobrunr.utils.mapper.jsonb.FieldAccessStrategy;
import org.jobrunr.utils.mapper.jsonb.JobRunrJsonb;
import org.jobrunr.utils.mapper.jsonb.NullSafeJsonBuilder;
import org.jobrunr.utils.mapper.jsonb.adapters.JobDetailsAdapter;
import org.jobrunr.utils.mapper.jsonb.serializer.DurationTypeDeserializer;
import org.jobrunr.utils.mapper.jsonb.serializer.DurationTypeSerializer;
import org.jobrunr.utils.mapper.jsonb.serializer.PathTypeDeserializer;
import org.jobrunr.utils.mapper.jsonb.serializer.PathTypeSerializer;

public class RecurringJobAdapter
implements JsonbAdapter<RecurringJob, JsonObject> {
    private final JobRunrJsonb jsonb;
    private final JobDetailsAdapter jobDetailsAdapter;

    public RecurringJobAdapter() {
        Jsonb jsonb = JsonbBuilder.create((JsonbConfig)new JsonbConfig().withNullValues(Boolean.valueOf(true)).withPropertyVisibilityStrategy((PropertyVisibilityStrategy)new FieldAccessStrategy()).withSerializers(new JsonbSerializer[]{new PathTypeSerializer(), new DurationTypeSerializer()}).withDeserializers(new JsonbDeserializer[]{new PathTypeDeserializer(), new DurationTypeDeserializer()}));
        this.jsonb = new JobRunrJsonb(jsonb);
        this.jobDetailsAdapter = new JobDetailsAdapter(this.jsonb);
    }

    public JsonObject adaptToJson(RecurringJob recurringJob) throws Exception {
        NullSafeJsonBuilder builder = NullSafeJsonBuilder.nullSafeJsonObjectBuilder().add("id", recurringJob.getId()).add("jobName", recurringJob.getJobName()).add("jobSignature", recurringJob.getJobSignature()).add("version", recurringJob.getVersion()).add("scheduleExpression", recurringJob.getScheduleExpression()).add("zoneId", recurringJob.getZoneId()).add("jobDetails", (JsonValue)this.jobDetailsAdapter.adaptToJson(recurringJob.getJobDetails())).add("createdAt", recurringJob.getCreatedAt().toString());
        if (recurringJob instanceof RecurringJobUIModel) {
            builder.add("nextRun", recurringJob.getNextRun().toString());
        }
        return builder.build();
    }

    public RecurringJob adaptFromJson(JsonObject jsonObject) throws Exception {
        RecurringJob recurringJob = new RecurringJob(jsonObject.getString("id"), this.jobDetailsAdapter.adaptFromJson(jsonObject.getJsonObject("jobDetails")), jsonObject.getString("scheduleExpression"), jsonObject.getString("zoneId"), jsonObject.getString("createdAt"));
        recurringJob.setJobName(jsonObject.getString("jobName"));
        return recurringJob;
    }
}

