/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.utils.reflection.autobox;

import java.math.BigDecimal;
import org.jobrunr.utils.reflection.ReflectionUtils;
import org.jobrunr.utils.reflection.autobox.TypeAutoboxer;

public class DoubleTypeAutoboxer
implements TypeAutoboxer<Double> {
    @Override
    public boolean supports(Class<?> type) {
        return Double.TYPE.equals(type) || Double.class.equals(type);
    }

    @Override
    public Double autobox(Object value, Class<Double> type) {
        if (value instanceof Double) {
            return (Double)ReflectionUtils.cast(value);
        }
        if (value instanceof BigDecimal) {
            return (Double)ReflectionUtils.cast(((BigDecimal)value).doubleValue());
        }
        if (value instanceof Integer) {
            return (double)((Integer)value);
        }
        throw new UnsupportedOperationException(String.format("Cannot autobox %s of type %s to %s", value, value.getClass().getName(), Double.class.getName()));
    }
}

