/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.utils.reflection.autobox;

import java.math.BigDecimal;
import org.jobrunr.utils.reflection.ReflectionUtils;
import org.jobrunr.utils.reflection.autobox.TypeAutoboxer;

public class FloatTypeAutoboxer
implements TypeAutoboxer<Float> {
    @Override
    public boolean supports(Class<?> type) {
        return Float.TYPE.equals(type) || Float.class.equals(type);
    }

    @Override
    public Float autobox(Object value, Class<Float> type) {
        if (value instanceof Float) {
            return (Float)ReflectionUtils.cast(value);
        }
        if (value instanceof BigDecimal) {
            return (Float)ReflectionUtils.cast(Float.valueOf(((BigDecimal)value).floatValue()));
        }
        if (value instanceof String) {
            return (Float)ReflectionUtils.cast(Long.valueOf((String)value));
        }
        throw new UnsupportedOperationException(String.format("Cannot autobox %s of type %s to %s", value, value.getClass().getName(), Long.class.getName()));
    }
}

