/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.utils.resources;

import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.ProviderNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jobrunr.utils.StringUtils;
import org.jobrunr.utils.resources.FileSystemProvider;

public class JarFileSystemProvider
implements FileSystemProvider {
    private final Map<String, FileSystem> openFileSystems = new HashMap<String, FileSystem>();

    @Override
    public Path toPath(URI uri) throws IOException {
        try {
            if (!"jar".equals(uri.getScheme())) {
                throw new IllegalArgumentException("JarFileSystemProvider only supports uri's starting with jar:");
            }
            String fileSystemName = StringUtils.substringBeforeLast(uri.toString(), "!");
            String path = StringUtils.substringAfterLast(uri.toString(), "!");
            FileSystem fs = this.getFileSystem(fileSystemName);
            return fs.getPath(path, new String[0]);
        }
        catch (ProviderNotFoundException e) {
            throw new ProviderNotFoundException("Provider not found for URI " + uri.toString());
        }
    }

    private FileSystem getFileSystem(String fileSystemName) throws IOException {
        if (!this.openFileSystems.containsKey(fileSystemName)) {
            if (!fileSystemName.contains("!")) {
                try {
                    this.openFileSystems.put(fileSystemName, FileSystems.newFileSystem(URI.create(fileSystemName), Collections.emptyMap(), null));
                }
                catch (FileSystemAlreadyExistsException e) {
                    this.openFileSystems.put(fileSystemName, FileSystems.getFileSystem(URI.create(fileSystemName)));
                }
            } else {
                FileSystem parent = this.getFileSystem(StringUtils.substringBeforeLast(fileSystemName, "!"));
                Path path = parent.getPath(StringUtils.substringAfterLast(fileSystemName, "!"), new String[0]);
                this.openFileSystems.put(fileSystemName, FileSystems.newFileSystem(path, ClassLoader.getSystemClassLoader()));
            }
        }
        return this.openFileSystems.get(fileSystemName);
    }

    @Override
    public void close() throws IOException {
        ArrayList<String> fileSystemNames = new ArrayList<String>(this.openFileSystems.keySet());
        int i = 3;
        while (i >= 0) {
            int finalI = i--;
            List<String> fileSystemsToClose = fileSystemNames.stream().filter(fsName -> fsName.chars().filter(ch -> ch == 33).count() == (long)finalI).collect(Collectors.toList());
            fileSystemsToClose.forEach(this::close);
            fileSystemsToClose.forEach(this.openFileSystems::remove);
        }
    }

    private void close(String fileSystemName) {
        try {
            this.openFileSystems.remove(fileSystemName).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

