/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.rdfparser.license;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EmptyStackException;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.SpdxDocumentContainer;
import org.spdx.rdfparser.license.AnyLicenseInfo;
import org.spdx.rdfparser.license.ConjunctiveLicenseSet;
import org.spdx.rdfparser.license.DisjunctiveLicenseSet;
import org.spdx.rdfparser.license.ExtractedLicenseInfo;
import org.spdx.rdfparser.license.LicenseException;
import org.spdx.rdfparser.license.LicenseInfoFactory;
import org.spdx.rdfparser.license.LicenseParserException;
import org.spdx.rdfparser.license.OrLaterOperator;
import org.spdx.rdfparser.license.SimpleLicensingInfo;
import org.spdx.rdfparser.license.SpdxNoAssertionLicense;
import org.spdx.rdfparser.license.SpdxNoneLicense;
import org.spdx.rdfparser.license.WithExceptionOperator;

public class LicenseExpressionParser {
    static final String LEFT_PAREN = "(";
    static final String RIGHT_PAREN = ")";
    static final Map<String, Operator> OPERATOR_MAP = Maps.newHashMap();

    static AnyLicenseInfo parseLicenseExpression(String expression, SpdxDocumentContainer container) throws InvalidSPDXAnalysisException {
        if (expression == null || expression.trim().isEmpty()) {
            throw new LicenseParserException("Empty license expression");
        }
        String[] tokens = LicenseExpressionParser.tokenizeExpression(expression);
        if (tokens.length == 1 && tokens[0].toLowerCase().equals("NOASSERTION".toLowerCase())) {
            return new SpdxNoAssertionLicense();
        }
        if (tokens.length == 1 && tokens[0].toLowerCase().equals("NONE".toLowerCase())) {
            return new SpdxNoneLicense();
        }
        try {
            return LicenseExpressionParser.parseLicenseExpression(tokens, container);
        }
        catch (EmptyStackException ex) {
            throw new LicenseParserException("Invalid license expression - check that every operator (e.g. AND and OR) has operators and that parenthesis are matched");
        }
    }

    private static String[] tokenizeExpression(String expression) {
        String[] startTokens = expression.split("\\s");
        ArrayList endTokens = Lists.newArrayList();
        for (String token : startTokens) {
            LicenseExpressionParser.processPreToken(token, endTokens);
        }
        return endTokens.toArray(new String[endTokens.size()]);
    }

    private static void processPreToken(String preToken, List<String> tokenList) {
        if (preToken.isEmpty()) {
            return;
        }
        if (preToken.startsWith(LEFT_PAREN)) {
            tokenList.add(LEFT_PAREN);
            LicenseExpressionParser.processPreToken(preToken.substring(1), tokenList);
        } else if (preToken.endsWith(RIGHT_PAREN)) {
            LicenseExpressionParser.processPreToken(preToken.substring(0, preToken.length() - 1), tokenList);
            tokenList.add(RIGHT_PAREN);
        } else if (preToken.endsWith("+")) {
            LicenseExpressionParser.processPreToken(preToken.substring(0, preToken.length() - 1), tokenList);
            tokenList.add("+");
        } else {
            tokenList.add(preToken);
        }
    }

    private static AnyLicenseInfo parseLicenseExpression(String[] tokens, SpdxDocumentContainer container) throws InvalidSPDXAnalysisException {
        if (tokens == null || tokens.length == 0) {
            throw new LicenseParserException("Expected license expression");
        }
        Stack<AnyLicenseInfo> operandStack = new Stack<AnyLicenseInfo>();
        Stack<Operator> operatorStack = new Stack<Operator>();
        int tokenIndex = 0;
        while (tokenIndex < tokens.length) {
            Operator tosOperator;
            String token;
            if (LEFT_PAREN.equals(token = tokens[tokenIndex++])) {
                int rightParenIndex = LicenseExpressionParser.findMatchingParen(tokens, tokenIndex);
                if (rightParenIndex < 0) {
                    throw new LicenseParserException("Missing right parenthesis");
                }
                String[] nestedTokens = Arrays.copyOfRange(tokens, tokenIndex, rightParenIndex);
                operandStack.push(LicenseExpressionParser.parseLicenseExpression(nestedTokens, container));
                tokenIndex = rightParenIndex + 1;
                continue;
            }
            if (OPERATOR_MAP.get(token.toLowerCase()) == null) {
                operandStack.push(LicenseExpressionParser.parseSimpleLicenseToken(token, container));
                continue;
            }
            Operator operator = OPERATOR_MAP.get(token.toLowerCase());
            if (operator == Operator.WITH) {
                if (!operatorStack.isEmpty() && Operator.OR_LATER.equals(operatorStack.peek())) {
                    tosOperator = (Operator)((Object)operatorStack.pop());
                    LicenseExpressionParser.evaluateExpression(tosOperator, operandStack);
                }
                if (tokenIndex >= tokens.length) {
                    throw new LicenseParserException("Missing exception clause");
                }
                token = tokens[tokenIndex++];
                LicenseException licenseException = null;
                licenseException = LicenseInfoFactory.isSPdxListedExceptionID(token) ? LicenseInfoFactory.getListedExceptionById(token) : new LicenseException(token);
                AnyLicenseInfo operand = operandStack.pop();
                if (operand == null) {
                    throw new LicenseParserException("Missing license for with clause");
                }
                if (!(operand instanceof SimpleLicensingInfo) && !(operand instanceof OrLaterOperator)) {
                    throw new LicenseParserException("License with exception is not of type SimpleLicensingInfo or OrLaterOperator");
                }
                operandStack.push(new WithExceptionOperator(operand, licenseException));
                continue;
            }
            while (!operatorStack.isEmpty() && ((Operator)((Object)operatorStack.peek())).ordinal() <= operator.ordinal()) {
                tosOperator = (Operator)((Object)operatorStack.pop());
                LicenseExpressionParser.evaluateExpression(tosOperator, operandStack);
            }
            operatorStack.push(operator);
        }
        while (!operatorStack.isEmpty()) {
            Operator tosOperator = (Operator)((Object)operatorStack.pop());
            LicenseExpressionParser.evaluateExpression(tosOperator, operandStack);
        }
        AnyLicenseInfo retval = (AnyLicenseInfo)operandStack.pop();
        if (!operandStack.isEmpty()) {
            throw new LicenseParserException("Invalid license expression.  Expecting more operands.");
        }
        return retval;
    }

    private static int findMatchingParen(String[] tokens, int startToken) {
        if (tokens == null) {
            return -1;
        }
        int nestCount = 0;
        for (int i = startToken; i < tokens.length; ++i) {
            if (LEFT_PAREN.equals(tokens[i])) {
                ++nestCount;
                continue;
            }
            if (!RIGHT_PAREN.equals(tokens[i])) continue;
            if (nestCount == 0) {
                return i;
            }
            --nestCount;
        }
        return -1;
    }

    private static AnyLicenseInfo parseSimpleLicenseToken(String token, SpdxDocumentContainer container) throws InvalidSPDXAnalysisException {
        if (LicenseInfoFactory.isSpdxListedLicenseID(token)) {
            return LicenseInfoFactory.getListedLicenseById(token);
        }
        ExtractedLicenseInfo retval = null;
        if (container != null) {
            if (container.extractedLicenseExists(token)) {
                retval = container.getExtractedLicense(token);
            } else {
                retval = new ExtractedLicenseInfo(token, null);
                container.addNewExtractedLicenseInfo(retval);
            }
        } else {
            retval = new ExtractedLicenseInfo(token, null);
        }
        return retval;
    }

    private static void evaluateExpression(Operator operator, Stack<AnyLicenseInfo> operandStack) throws InvalidSPDXAnalysisException {
        if (operator == Operator.OR_LATER) {
            AnyLicenseInfo license = operandStack.pop();
            if (!(license instanceof SimpleLicensingInfo)) {
                throw new LicenseParserException("Missing license for the '+' or later operator");
            }
            operandStack.push(new OrLaterOperator((SimpleLicensingInfo)license));
        } else {
            AnyLicenseInfo operand2 = operandStack.pop();
            AnyLicenseInfo operand1 = operandStack.pop();
            if (operand1 == null || operand2 == null) {
                throw new LicenseParserException("Missing operands for the " + operator.toString() + " operator");
            }
            operandStack.push(LicenseExpressionParser.evaluateBinary(operator, operand1, operand2));
        }
    }

    private static AnyLicenseInfo evaluateBinary(Operator tosOperator, AnyLicenseInfo operand1, AnyLicenseInfo operand2) throws InvalidSPDXAnalysisException {
        if (tosOperator == Operator.AND) {
            if (operand1 instanceof ConjunctiveLicenseSet) {
                AnyLicenseInfo[] origMembers = ((ConjunctiveLicenseSet)operand1).getMembers();
                AnyLicenseInfo[] newMembers = Arrays.copyOf(origMembers, origMembers.length + 1);
                newMembers[origMembers.length] = operand2;
                ((ConjunctiveLicenseSet)operand1).setMembers(newMembers);
                return operand1;
            }
            AnyLicenseInfo[] members = new AnyLicenseInfo[]{operand1, operand2};
            return new ConjunctiveLicenseSet(members);
        }
        if (tosOperator == Operator.OR) {
            if (operand1 instanceof DisjunctiveLicenseSet) {
                AnyLicenseInfo[] origMembers = ((DisjunctiveLicenseSet)operand1).getMembers();
                AnyLicenseInfo[] newMembers = Arrays.copyOf(origMembers, origMembers.length + 1);
                newMembers[origMembers.length] = operand2;
                ((DisjunctiveLicenseSet)operand1).setMembers(newMembers);
                return operand1;
            }
            AnyLicenseInfo[] members = new AnyLicenseInfo[]{operand1, operand2};
            return new DisjunctiveLicenseSet(members);
        }
        throw new LicenseParserException("Unknown operator " + tosOperator.toString());
    }

    static {
        OPERATOR_MAP.put("+", Operator.OR_LATER);
        OPERATOR_MAP.put("and", Operator.AND);
        OPERATOR_MAP.put("or", Operator.OR);
        OPERATOR_MAP.put("with", Operator.WITH);
    }

    static enum Operator {
        OR_LATER,
        WITH,
        AND,
        OR;

    }
}

