/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.client.util;

import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.elasticsearch.client.analytics.InferencePipelineAggregationBuilder;
import org.elasticsearch.client.analytics.ParsedInference;
import org.elasticsearch.client.analytics.ParsedStringStats;
import org.elasticsearch.client.analytics.ParsedTopMetrics;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.bucket.adjacency.ParsedAdjacencyMatrix;
import org.elasticsearch.search.aggregations.bucket.composite.ParsedComposite;
import org.elasticsearch.search.aggregations.bucket.filter.ParsedFilter;
import org.elasticsearch.search.aggregations.bucket.filter.ParsedFilters;
import org.elasticsearch.search.aggregations.bucket.geogrid.ParsedGeoHashGrid;
import org.elasticsearch.search.aggregations.bucket.geogrid.ParsedGeoTileGrid;
import org.elasticsearch.search.aggregations.bucket.global.ParsedGlobal;
import org.elasticsearch.search.aggregations.bucket.histogram.ParsedAutoDateHistogram;
import org.elasticsearch.search.aggregations.bucket.histogram.ParsedDateHistogram;
import org.elasticsearch.search.aggregations.bucket.histogram.ParsedHistogram;
import org.elasticsearch.search.aggregations.bucket.histogram.ParsedVariableWidthHistogram;
import org.elasticsearch.search.aggregations.bucket.missing.ParsedMissing;
import org.elasticsearch.search.aggregations.bucket.nested.ParsedNested;
import org.elasticsearch.search.aggregations.bucket.nested.ParsedReverseNested;
import org.elasticsearch.search.aggregations.bucket.range.ParsedBinaryRange;
import org.elasticsearch.search.aggregations.bucket.range.ParsedDateRange;
import org.elasticsearch.search.aggregations.bucket.range.ParsedGeoDistance;
import org.elasticsearch.search.aggregations.bucket.range.ParsedRange;
import org.elasticsearch.search.aggregations.bucket.sampler.ParsedSampler;
import org.elasticsearch.search.aggregations.bucket.terms.ParsedDoubleTerms;
import org.elasticsearch.search.aggregations.bucket.terms.ParsedLongRareTerms;
import org.elasticsearch.search.aggregations.bucket.terms.ParsedLongTerms;
import org.elasticsearch.search.aggregations.bucket.terms.ParsedSignificantLongTerms;
import org.elasticsearch.search.aggregations.bucket.terms.ParsedSignificantStringTerms;
import org.elasticsearch.search.aggregations.bucket.terms.ParsedStringRareTerms;
import org.elasticsearch.search.aggregations.bucket.terms.ParsedStringTerms;
import org.elasticsearch.search.aggregations.metrics.ParsedAvg;
import org.elasticsearch.search.aggregations.metrics.ParsedCardinality;
import org.elasticsearch.search.aggregations.metrics.ParsedExtendedStats;
import org.elasticsearch.search.aggregations.metrics.ParsedGeoBounds;
import org.elasticsearch.search.aggregations.metrics.ParsedGeoCentroid;
import org.elasticsearch.search.aggregations.metrics.ParsedHDRPercentileRanks;
import org.elasticsearch.search.aggregations.metrics.ParsedHDRPercentiles;
import org.elasticsearch.search.aggregations.metrics.ParsedMax;
import org.elasticsearch.search.aggregations.metrics.ParsedMedianAbsoluteDeviation;
import org.elasticsearch.search.aggregations.metrics.ParsedMin;
import org.elasticsearch.search.aggregations.metrics.ParsedScriptedMetric;
import org.elasticsearch.search.aggregations.metrics.ParsedStats;
import org.elasticsearch.search.aggregations.metrics.ParsedSum;
import org.elasticsearch.search.aggregations.metrics.ParsedTDigestPercentileRanks;
import org.elasticsearch.search.aggregations.metrics.ParsedTDigestPercentiles;
import org.elasticsearch.search.aggregations.metrics.ParsedTopHits;
import org.elasticsearch.search.aggregations.metrics.ParsedValueCount;
import org.elasticsearch.search.aggregations.metrics.ParsedWeightedAvg;
import org.elasticsearch.search.aggregations.pipeline.ParsedBucketMetricValue;
import org.elasticsearch.search.aggregations.pipeline.ParsedDerivative;
import org.elasticsearch.search.aggregations.pipeline.ParsedExtendedStatsBucket;
import org.elasticsearch.search.aggregations.pipeline.ParsedPercentilesBucket;
import org.elasticsearch.search.aggregations.pipeline.ParsedSimpleValue;
import org.elasticsearch.search.aggregations.pipeline.ParsedStatsBucket;
import org.elasticsearch.search.suggest.Suggest;
import org.elasticsearch.search.suggest.completion.CompletionSuggestion;
import org.elasticsearch.search.suggest.phrase.PhraseSuggestion;
import org.elasticsearch.search.suggest.term.TermSuggestion;
import org.elasticsearch.xcontent.ContextParser;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentParser;

public class NamedXContents {
    private NamedXContents() {
    }

    public static List<NamedXContentRegistry.Entry> getDefaultNamedXContents() {
        HashMap<String, ContextParser> map = new HashMap<String, ContextParser>();
        map.put("cardinality", (p, c) -> ParsedCardinality.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("hdr_percentiles", (p, c) -> ParsedHDRPercentiles.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("hdr_percentile_ranks", (p, c) -> ParsedHDRPercentileRanks.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("tdigest_percentiles", (p, c) -> ParsedTDigestPercentiles.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("tdigest_percentile_ranks", (p, c) -> ParsedTDigestPercentileRanks.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("percentiles_bucket", (p, c) -> ParsedPercentilesBucket.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("median_absolute_deviation", (p, c) -> ParsedMedianAbsoluteDeviation.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("min", (p, c) -> ParsedMin.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("max", (p, c) -> ParsedMax.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("sum", (p, c) -> ParsedSum.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("avg", (p, c) -> ParsedAvg.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("weighted_avg", (p, c) -> ParsedWeightedAvg.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("value_count", (p, c) -> ParsedValueCount.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("simple_value", (p, c) -> ParsedSimpleValue.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("derivative", (p, c) -> ParsedDerivative.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("bucket_metric_value", (p, c) -> ParsedBucketMetricValue.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("stats", (p, c) -> ParsedStats.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("stats_bucket", (p, c) -> ParsedStatsBucket.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("extended_stats", (p, c) -> ParsedExtendedStats.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("extended_stats_bucket", (p, c) -> ParsedExtendedStatsBucket.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("geo_bounds", (p, c) -> ParsedGeoBounds.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("geo_centroid", (p, c) -> ParsedGeoCentroid.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("histogram", (p, c) -> ParsedHistogram.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("date_histogram", (p, c) -> ParsedDateHistogram.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("auto_date_histogram", (p, c) -> ParsedAutoDateHistogram.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("variable_width_histogram", (p, c) -> ParsedVariableWidthHistogram.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("sterms", (p, c) -> ParsedStringTerms.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("lterms", (p, c) -> ParsedLongTerms.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("dterms", (p, c) -> ParsedDoubleTerms.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("lrareterms", (p, c) -> ParsedLongRareTerms.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("srareterms", (p, c) -> ParsedStringRareTerms.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("missing", (p, c) -> ParsedMissing.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("nested", (p, c) -> ParsedNested.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("reverse_nested", (p, c) -> ParsedReverseNested.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("global", (p, c) -> ParsedGlobal.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("filter", (p, c) -> ParsedFilter.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("sampler", (p, c) -> ParsedSampler.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("geohash_grid", (p, c) -> ParsedGeoHashGrid.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("geotile_grid", (p, c) -> ParsedGeoTileGrid.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("range", (p, c) -> ParsedRange.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("date_range", (p, c) -> ParsedDateRange.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("geo_distance", (p, c) -> ParsedGeoDistance.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("filters", (p, c) -> ParsedFilters.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("adjacency_matrix", (p, c) -> ParsedAdjacencyMatrix.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("siglterms", (p, c) -> ParsedSignificantLongTerms.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("sigsterms", (p, c) -> ParsedSignificantStringTerms.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("scripted_metric", (p, c) -> ParsedScriptedMetric.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("ip_range", (p, c) -> ParsedBinaryRange.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("top_hits", (p, c) -> ParsedTopHits.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("composite", (p, c) -> ParsedComposite.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("string_stats", (p, c) -> (ParsedStringStats)ParsedStringStats.PARSER.parse(p, (Object)((String)c)));
        map.put("top_metrics", (p, c) -> (ParsedTopMetrics)ParsedTopMetrics.PARSER.parse(p, (Object)((String)c)));
        map.put(InferencePipelineAggregationBuilder.NAME, (p, c) -> ParsedInference.fromXContent((XContentParser)p, (String)((String)c)));
        List<NamedXContentRegistry.Entry> entries = map.entrySet().stream().map(entry -> new NamedXContentRegistry.Entry(Aggregation.class, new ParseField((String)entry.getKey(), new String[0]), (ContextParser)entry.getValue())).collect(Collectors.toList());
        entries.add(new NamedXContentRegistry.Entry(Suggest.Suggestion.class, new ParseField("term", new String[0]), (parser, context) -> TermSuggestion.fromXContent((XContentParser)parser, (String)((String)context))));
        entries.add(new NamedXContentRegistry.Entry(Suggest.Suggestion.class, new ParseField("phrase", new String[0]), (parser, context) -> PhraseSuggestion.fromXContent((XContentParser)parser, (String)((String)context))));
        entries.add(new NamedXContentRegistry.Entry(Suggest.Suggestion.class, new ParseField("completion", new String[0]), (parser, context) -> CompletionSuggestion.fromXContent((XContentParser)parser, (String)((String)context))));
        return entries;
    }
}

