/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.core.oidc;

import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.springframework.security.oauth2.core.oidc.StandardClaimAccessor;
import org.springframework.util.Assert;

public class OidcUserInfo
implements StandardClaimAccessor,
Serializable {
    private static final long serialVersionUID = 570L;
    private final Map<String, Object> claims;

    public OidcUserInfo(Map<String, Object> claims) {
        Assert.notEmpty(claims, (String)"claims cannot be empty");
        this.claims = Collections.unmodifiableMap(new LinkedHashMap<String, Object>(claims));
    }

    @Override
    public Map<String, Object> getClaims() {
        return this.claims;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        OidcUserInfo that = (OidcUserInfo)obj;
        return this.getClaims().equals(that.getClaims());
    }

    public int hashCode() {
        return this.getClaims().hashCode();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final Map<String, Object> claims = new LinkedHashMap<String, Object>();

        private Builder() {
        }

        public Builder claim(String name, Object value) {
            this.claims.put(name, value);
            return this;
        }

        public Builder claims(Consumer<Map<String, Object>> claimsConsumer) {
            claimsConsumer.accept(this.claims);
            return this;
        }

        public Builder address(String address) {
            return this.claim("address", address);
        }

        public Builder birthdate(String birthdate) {
            return this.claim("birthdate", birthdate);
        }

        public Builder email(String email) {
            return this.claim("email", email);
        }

        public Builder emailVerified(Boolean emailVerified) {
            return this.claim("email_verified", emailVerified);
        }

        public Builder familyName(String familyName) {
            return this.claim("family_name", familyName);
        }

        public Builder gender(String gender) {
            return this.claim("gender", gender);
        }

        public Builder givenName(String givenName) {
            return this.claim("given_name", givenName);
        }

        public Builder locale(String locale) {
            return this.claim("locale", locale);
        }

        public Builder middleName(String middleName) {
            return this.claim("middle_name", middleName);
        }

        public Builder name(String name) {
            return this.claim("name", name);
        }

        public Builder nickname(String nickname) {
            return this.claim("nickname", nickname);
        }

        public Builder picture(String picture) {
            return this.claim("picture", picture);
        }

        public Builder phoneNumber(String phoneNumber) {
            return this.claim("phone_number", phoneNumber);
        }

        public Builder phoneNumberVerified(String phoneNumberVerified) {
            return this.claim("phone_number_verified", phoneNumberVerified);
        }

        public Builder preferredUsername(String preferredUsername) {
            return this.claim("preferred_username", preferredUsername);
        }

        public Builder profile(String profile) {
            return this.claim("profile", profile);
        }

        public Builder subject(String subject) {
            return this.claim("sub", subject);
        }

        public Builder updatedAt(String updatedAt) {
            return this.claim("updated_at", updatedAt);
        }

        public Builder website(String website) {
            return this.claim("website", website);
        }

        public Builder zoneinfo(String zoneinfo) {
            return this.claim("zoneinfo", zoneinfo);
        }

        public OidcUserInfo build() {
            return new OidcUserInfo(this.claims);
        }
    }
}

