"use strict";
/********************************************************************************
 * Copyright (c) 2020 TypeFox and others
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * SPDX-License-Identifier: EPL-2.0
 ********************************************************************************/
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const registry_1 = require("./registry");
const util_1 = require("./util");
/**
 * Creates a namespace (corresponds to `publisher` in package.json).
 */
function createNamespace(options = {}) {
    return __awaiter(this, void 0, void 0, function* () {
        util_1.addEnvOptions(options);
        if (!options.name) {
            throw new Error('The namespace name is mandatory.');
        }
        if (!options.pat) {
            throw new Error("A personal access token must be given with the option '--pat'.");
        }
        const registry = new registry_1.Registry(options);
        const result = yield registry.createNamespace(options.name, options.pat);
        if (result.error) {
            throw new Error(result.error);
        }
        console.log(`\ud83d\ude80  Created namespace ${options.name}`);
    });
}
exports.createNamespace = createNamespace;
//# sourceMappingURL=create-namespace.js.map