"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
/********************************************************************************
 * Copyright (c) 2019 TypeFox and others
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * SPDX-License-Identifier: EPL-2.0
 ********************************************************************************/
const vsce_1 = require("vsce");
const util_1 = require("./util");
const registry_1 = require("./registry");
const check_license_1 = require("./check-license");
/**
 * Publishes an extension.
 */
function publish(options = {}) {
    return __awaiter(this, void 0, void 0, function* () {
        util_1.addEnvOptions(options);
        const internalPublishOptions = [];
        const packagePaths = options.packagePath || [undefined];
        const targets = options.targets || [undefined];
        for (const packagePath of packagePaths) {
            for (const target of targets) {
                internalPublishOptions.push(Object.assign(Object.assign({}, options), { packagePath: packagePath, target: target }));
            }
        }
        yield Promise.all(internalPublishOptions.map(publishOptions => doPublish(publishOptions)));
    });
}
exports.publish = publish;
function doPublish(options = {}) {
    return __awaiter(this, void 0, void 0, function* () {
        if (!options.pat) {
            throw new Error("A personal access token must be given with the option '--pat'.");
        }
        // if the packagePath is a link to a vsix, don't need to package it
        if (options.packagePath && options.packagePath.endsWith('.vsix')) {
            options.extensionFile = options.packagePath;
            delete options.packagePath;
            delete options.target;
        }
        const registry = new registry_1.Registry(options);
        if (!options.extensionFile) {
            yield packageExtension(options, registry);
            console.log(); // new line
        }
        else if (options.preRelease) {
            console.warn("Ignoring option '--pre-release' for prepackaged extension.");
        }
        const extension = yield registry.publish(options.extensionFile, options.pat);
        if (extension.error) {
            throw new Error(extension.error);
        }
        const name = `${extension.namespace}.${extension.name}`;
        let description = `${name} v${extension.version}`;
        if (options.target) {
            description += `@${options.target}`;
        }
        console.log(`\ud83d\ude80  Published ${description}`);
        if (extension.warning) {
            console.log(`\n!!  ${extension.warning}`);
        }
    });
}
function packageExtension(options, registry) {
    return __awaiter(this, void 0, void 0, function* () {
        if (registry.requiresLicense) {
            yield check_license_1.checkLicense(options.packagePath);
        }
        options.extensionFile = yield util_1.createTempFile({ postfix: '.vsix' });
        const createVSIXOptions = {
            target: options.target,
            cwd: options.packagePath,
            packagePath: options.extensionFile,
            baseContentUrl: options.baseContentUrl,
            baseImagesUrl: options.baseImagesUrl,
            useYarn: options.yarn,
            preRelease: options.preRelease
        };
        yield vsce_1.createVSIX(createVSIXOptions);
    });
}
//# sourceMappingURL=publish.js.map