/********************************************************************************
 * Copyright (c) 2019 TypeFox and others
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * SPDX-License-Identifier: EPL-2.0
 ********************************************************************************/
/// <reference types="node" />
import * as fs from 'fs';
import * as tmp from 'tmp';
import * as http from 'http';
import { RegistryOptions } from './registry';
export { promisify } from 'util';
export declare function addEnvOptions(options: RegistryOptions): void;
export declare function matchExtensionId(id: string): RegExpExecArray | null;
export declare function optionalStat(path: fs.PathLike): Promise<fs.Stats | undefined>;
export declare function makeDirs(path: fs.PathLike): Promise<void>;
export declare function createTempFile(options: tmp.TmpNameOptions): Promise<string>;
export declare function handleError(debug?: boolean, additionalMessage?: string): (reason: any) => void;
export declare function statusError(response: http.IncomingMessage): Error;
export declare function readFile(name: string, packagePath?: string, encoding?: string): Promise<string>;
export declare function readManifest(packagePath?: string): Promise<Manifest>;
export declare function validateManifest(manifest: Manifest): void;
export declare function writeFile(name: string, content: string, packagePath?: string, encoding?: string): Promise<void>;
export declare function writeManifest(manifest: Manifest, packagePath?: string): Promise<void>;
export interface Manifest {
    publisher: string;
    name: string;
    version: string;
    license?: string;
}
export declare function getUserInput(text: string): Promise<string>;
export declare function getUserChoice<R extends string>(text: string, values: R[], defaultValue: R, lowerCase?: boolean): Promise<R>;
//# sourceMappingURL=util.d.ts.map