"use strict";
/********************************************************************************
 * Copyright (c) 2019 TypeFox and others
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * SPDX-License-Identifier: EPL-2.0
 ********************************************************************************/
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const fs = require("fs");
const path = require("path");
const tmp = require("tmp");
const readline = require("readline");
var util_1 = require("util");
exports.promisify = util_1.promisify;
function addEnvOptions(options) {
    if (!options.registryUrl) {
        options.registryUrl = process.env.OVSX_REGISTRY_URL;
    }
    if (!options.pat) {
        options.pat = process.env.OVSX_PAT;
    }
    if (!options.username) {
        options.username = process.env.OVSX_USERNAME;
    }
    if (!options.password) {
        options.password = process.env.OVSX_PASSWORD;
    }
}
exports.addEnvOptions = addEnvOptions;
function matchExtensionId(id) {
    return /^([\w-]+)(?:\.|\/)([\w-]+)$/.exec(id);
}
exports.matchExtensionId = matchExtensionId;
function optionalStat(path) {
    return new Promise((resolve, reject) => {
        fs.stat(path, (err, stats) => resolve(stats));
    });
}
exports.optionalStat = optionalStat;
function makeDirs(path) {
    return new Promise((resolve, reject) => {
        if (fs.existsSync(path)) {
            resolve();
        }
        else {
            fs.mkdir(path, { recursive: true }, err => {
                if (err)
                    reject(err);
                else
                    resolve();
            });
        }
    });
}
exports.makeDirs = makeDirs;
function createTempFile(options) {
    return new Promise((resolve, reject) => {
        tmp.tmpName(options, (err, name) => {
            if (err)
                reject(err);
            else
                resolve(name);
        });
    });
}
exports.createTempFile = createTempFile;
function handleError(debug, additionalMessage) {
    return reason => {
        if (reason instanceof Error && !debug) {
            console.error(`\u274c  ${reason.message}`);
            if (additionalMessage) {
                console.error(additionalMessage);
            }
        }
        else if (typeof reason === 'string') {
            console.error(`\u274c  ${reason}`);
        }
        else if (reason !== undefined) {
            console.error(reason);
        }
        else {
            console.error('An unknown error occurred.');
        }
        process.exit(1);
    };
}
exports.handleError = handleError;
function statusError(response) {
    if (response.statusMessage)
        return new Error(`The server responded with status ${response.statusCode}: ${response.statusMessage}`);
    else
        return new Error(`The server responded with status ${response.statusCode}.`);
}
exports.statusError = statusError;
function readFile(name, packagePath, encoding = 'utf-8') {
    return new Promise((resolve, reject) => {
        fs.readFile(path.join(packagePath || process.cwd(), name), { encoding }, (err, content) => {
            if (err) {
                reject(err);
            }
            else {
                resolve(content);
            }
        });
    });
}
exports.readFile = readFile;
function readManifest(packagePath) {
    return __awaiter(this, void 0, void 0, function* () {
        const content = yield readFile('package.json', packagePath);
        return JSON.parse(content);
    });
}
exports.readManifest = readManifest;
function validateManifest(manifest) {
    if (!manifest.publisher) {
        throw new Error("Missing required field 'publisher'.");
    }
    if (!manifest.name) {
        throw new Error("Missing required field 'name'.");
    }
    if (!manifest.version) {
        throw new Error("Missing required field 'version'.");
    }
}
exports.validateManifest = validateManifest;
function writeFile(name, content, packagePath, encoding = 'utf-8') {
    return new Promise((resolve, reject) => {
        fs.writeFile(path.join(packagePath || process.cwd(), name), content, { encoding }, err => {
            if (err) {
                reject(err);
            }
            else {
                resolve();
            }
        });
    });
}
exports.writeFile = writeFile;
function writeManifest(manifest, packagePath) {
    const content = JSON.stringify(manifest, null, 4);
    return writeFile('package.json', content, packagePath);
}
exports.writeManifest = writeManifest;
function getUserInput(text) {
    return new Promise(resolve => {
        const rl = readline.createInterface({ input: process.stdin, output: process.stdout });
        rl.question(text, answer => {
            resolve(answer);
            rl.close();
        });
    });
}
exports.getUserInput = getUserInput;
function getUserChoice(text, values, defaultValue, lowerCase = true) {
    return __awaiter(this, void 0, void 0, function* () {
        const prompt = text + '\n' + values.map(v => v === defaultValue ? `[${v}]` : v).join('/') + ': ';
        const answer = yield getUserInput(prompt);
        if (!answer) {
            return defaultValue;
        }
        const lcAnswer = lowerCase ? answer.toLowerCase() : answer;
        for (const value of values) {
            if (value.startsWith(lcAnswer)) {
                return value;
            }
        }
        return defaultValue;
    });
}
exports.getUserChoice = getUserChoice;
//# sourceMappingURL=util.js.map