/**********************************************************************
 * Copyright (c) 2021 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 ***********************************************************************/
export interface YarnWorkspace {
    name: string;
    location: string;
    workspaceDependencies: string[];
    mismatchedWorkspaceDependencies: string[];
}
/**
 * Update root tsconfig.json file
 */
export declare function updateRootTsConfigFile(rootFolder: string): Promise<void>;
/**
 * Update /theia/examples/assembly tsconfig.json file
 */
export declare function updateAssemblyTsConfigFile(rootFolder: string, assemblyFolder: string): Promise<void>;
export declare function updateTypescriptReferencesFor(packagePath: string, dependencies: string[], yarnWorkspaces: Map<string, YarnWorkspace>): Promise<void>;
//# sourceMappingURL=resolve-tsconfigs.d.ts.map