"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.readVSIXPackage = exports.readZip = void 0;
const yauzl_1 = require("yauzl");
const xml_1 = require("./xml");
const util_1 = require("util");
function bufferStream(stream) {
    return __awaiter(this, void 0, void 0, function* () {
        return yield new Promise((c, e) => {
            const buffers = [];
            stream.on('data', buffer => buffers.push(buffer));
            stream.once('error', e);
            stream.once('end', () => c(Buffer.concat(buffers)));
        });
    });
}
function readZip(packagePath, filter) {
    return __awaiter(this, void 0, void 0, function* () {
        const zipfile = yield util_1.promisify(yauzl_1.open)(packagePath, { lazyEntries: true });
        return yield new Promise((c, e) => {
            const result = new Map();
            zipfile.once('close', () => c(result));
            zipfile.readEntry();
            zipfile.on('entry', (entry) => {
                const name = entry.fileName.toLowerCase();
                if (filter(name)) {
                    zipfile.openReadStream(entry, (err, stream) => {
                        if (err) {
                            zipfile.close();
                            return e(err);
                        }
                        bufferStream(stream).then(buffer => {
                            result.set(name, buffer);
                            zipfile.readEntry();
                        });
                    });
                }
                else {
                    zipfile.readEntry();
                }
            });
        });
    });
}
exports.readZip = readZip;
function readVSIXPackage(packagePath) {
    return __awaiter(this, void 0, void 0, function* () {
        const map = yield readZip(packagePath, name => /^extension\/package\.json$|^extension\.vsixmanifest$/i.test(name));
        const rawManifest = map.get('extension/package.json');
        if (!rawManifest) {
            throw new Error('Manifest not found');
        }
        const rawXmlManifest = map.get('extension.vsixmanifest');
        if (!rawXmlManifest) {
            throw new Error('VSIX manifest not found');
        }
        return {
            manifest: JSON.parse(rawManifest.toString('utf8')),
            xmlManifest: yield xml_1.parseXmlManifest(rawXmlManifest.toString('utf8')),
        };
    });
}
exports.readVSIXPackage = readVSIXPackage;
//# sourceMappingURL=zip.js.map