"use strict";
/********************************************************************************
 * Copyright (C) 2017 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
exports.AbstractGenerator = void 0;
const os = require("os");
const fs = require("fs-extra");
class AbstractGenerator {
    constructor(pck, options = {}) {
        this.pck = pck;
        this.options = options;
    }
    compileFrontendModuleImports(modules) {
        var _a;
        const splitFrontend = (_a = this.options.splitFrontend) !== null && _a !== void 0 ? _a : this.options.mode !== 'production';
        return this.compileModuleImports(modules, splitFrontend ? 'import' : 'require');
    }
    compileBackendModuleImports(modules) {
        return this.compileModuleImports(modules, 'require');
    }
    compileElectronMainModuleImports(modules) {
        return modules && this.compileModuleImports(modules, 'require') || '';
    }
    compileModuleImports(modules, fn) {
        if (modules.size === 0) {
            return '';
        }
        const lines = Array.from(modules.keys()).map(moduleName => {
            const invocation = `${fn}('${modules.get(moduleName)}')`;
            if (fn === 'require') {
                return `Promise.resolve(${invocation})`;
            }
            return invocation;
        }).map(statement => `    .then(function () { return ${statement}.then(load) })`);
        return os.EOL + lines.join(os.EOL);
    }
    ifBrowser(value, defaultValue = '') {
        return this.pck.ifBrowser(value, defaultValue);
    }
    ifElectron(value, defaultValue = '') {
        return this.pck.ifElectron(value, defaultValue);
    }
    async write(path, content) {
        await fs.ensureFile(path);
        await fs.writeFile(path, content);
    }
    ifMonaco(value, defaultValue = () => '') {
        return (this.pck.extensionPackages.some(e => e.name === '@theia/monaco') ? value : defaultValue)();
    }
    prettyStringify(object) {
        // eslint-disable-next-line no-null/no-null
        return JSON.stringify(object, null, 4);
    }
}
exports.AbstractGenerator = AbstractGenerator;
//# sourceMappingURL=abstract-generator.js.map