/********************************************************************************
 * Copyright (C) 2020 Ericsson and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
declare global {
    interface Array<T> {
        flat(depth?: number): any;
    }
}
import { RequestInit, Response } from 'node-fetch';
export declare const extensionPackCacheName = ".packs";
/**
 * Available options when downloading.
 */
export interface DownloadPluginsOptions {
    /**
     * Determines if a plugin should be unpacked.
     * Defaults to `false`.
     */
    packed?: boolean;
    /**
     * Determines if failures while downloading plugins should be ignored.
     * Defaults to `false`.
     */
    ignoreErrors?: boolean;
    /**
     * The supported vscode API version.
     * Used to determine extension compatibility.
     */
    apiVersion?: string;
    /**
     * The open-vsx registry API url.
     */
    apiUrl?: string;
}
export default function downloadPlugins(options?: DownloadPluginsOptions): Promise<void>;
/**
 * Follow HTTP(S)_PROXY, ALL_PROXY and NO_PROXY environment variables.
 */
export declare function xfetch(url: string, options?: RequestInit): Promise<Response>;
//# sourceMappingURL=download-plugins.d.ts.map