/********************************************************************************
 * Copyright (C) 2021 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
import { VSXAllVersions, VSXExtensionRaw, VSXSearchEntry, VSXSearchParam, VSXSearchResult } from './ovsx-types';
export interface OVSXClientOptions {
    apiVersion: string;
    apiUrl: string;
}
export declare class OVSXClient {
    readonly options: OVSXClientOptions;
    constructor(options: OVSXClientOptions);
    search(param?: VSXSearchParam): Promise<VSXSearchResult>;
    protected buildSearchUri(param?: VSXSearchParam): Promise<string>;
    getExtension(id: string): Promise<VSXExtensionRaw>;
    /**
     * Get all versions of the given extension.
     * @param id the requested extension id.
     */
    getAllVersions(id: string): Promise<VSXExtensionRaw[]>;
    protected fetchJson<R>(url: string): Promise<R>;
    protected postJson<P, R>(url: string, payload: P): Promise<R>;
    fetchText(url: string): Promise<string>;
    /**
     * Get the latest compatible extension version.
     * - a builtin extension is fetched based on the extension version which matches the API.
     * - an extension satisfies compatibility if its `engines.vscode` version is supported.
     * @param id the extension id.
     *
     * @returns the data for the latest compatible extension version if available, else `undefined`.
     */
    getLatestCompatibleExtensionVersion(id: string): Promise<VSXExtensionRaw | undefined>;
    /**
     * Get the latest compatible version of an extension.
     * @param entry the extension search entry.
     *
     * @returns the latest compatible version of an extension if it exists, else `undefined`.
     */
    getLatestCompatibleVersion(entry: VSXSearchEntry): VSXAllVersions | undefined;
    /**
     * Determine if the engine is supported by the application.
     * @param engine the engine.
     *
     * @returns `true` if the engine satisfies the API version.
     */
    protected isEngineSupported(engine?: string): boolean;
    /**
     * Determines if the extension namespace is a builtin maintained by the framework.
     * @param namespace the extension namespace to verify.
     */
    protected isBuiltinNamespace(namespace: string): boolean;
    /**
     * Determines if the first version is less than or equal the second version.
     * - v1 <= v2.
     * @param a the first semver version.
     * @param b the second semver version.
     */
    protected isVersionLTE(a: string, b: string): boolean;
}
//# sourceMappingURL=ovsx-client.d.ts.map