/********************************************************************************
 * Copyright (c) 2021 SAP SE or an SAP affiliate company and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
/// <reference types="@theia/monaco-editor-core/monaco" />
import { TreeNode, CompositeTreeNode, SelectableTreeNode, ExpandableTreeNode, TreeImpl } from '@theia/core/lib/browser';
import { UriSelection } from '@theia/core/lib/common/selection';
export declare class BulkEditTree extends TreeImpl {
    initTree(edits: monaco.editor.ResourceEdit[], fileContents: Map<string, string>): Promise<void>;
    private getChildren;
    private createBulkEditNode;
    private createBulkEditInfo;
    private getResourcePath;
}
export interface BulkEditNode extends UriSelection, SelectableTreeNode {
    parent: CompositeTreeNode;
    bulkEdit: monaco.editor.ResourceFileEdit | monaco.editor.ResourceTextEdit;
}
export declare namespace BulkEditNode {
    function is(node: TreeNode | undefined): node is BulkEditNode;
}
export interface BulkEditInfoNode extends UriSelection, SelectableTreeNode, ExpandableTreeNode {
    parent: CompositeTreeNode;
    fileContents?: string;
}
export declare namespace BulkEditInfoNode {
    function is(node: Object | undefined): node is BulkEditInfoNode;
}
//# sourceMappingURL=bulk-edit-tree.d.ts.map