/********************************************************************************
 * Copyright (C) 2021 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
import { Emitter, Event, Disposable, DisposableCollection } from '@theia/core';
import { ConsoleSession } from './console-session';
import { Severity } from '@theia/core/lib/common/severity';
export declare class ConsoleSessionManager implements Disposable {
    protected readonly sessions: Map<string, ConsoleSession>;
    protected _selectedSession: ConsoleSession | undefined;
    protected _severity: Severity | undefined;
    protected readonly sessionAddedEmitter: Emitter<ConsoleSession>;
    protected readonly sessionDeletedEmitter: Emitter<ConsoleSession>;
    protected readonly sessionWasShownEmitter: Emitter<ConsoleSession>;
    protected readonly sessionWasHiddenEmitter: Emitter<ConsoleSession>;
    protected readonly selectedSessionChangedEmitter: Emitter<ConsoleSession | undefined>;
    protected readonly severityChangedEmitter: Emitter<void>;
    get onDidAddSession(): Event<ConsoleSession>;
    get onDidDeleteSession(): Event<ConsoleSession>;
    get onDidShowSession(): Event<ConsoleSession>;
    get onDidHideSession(): Event<ConsoleSession>;
    get onDidChangeSelectedSession(): Event<ConsoleSession | undefined>;
    get onDidChangeSeverity(): Event<void>;
    protected readonly toDispose: DisposableCollection;
    protected readonly toDisposeOnSessionDeletion: Map<string, Disposable>;
    dispose(): void;
    get severity(): Severity | undefined;
    set severity(value: Severity | undefined);
    get all(): ConsoleSession[];
    get selectedSession(): ConsoleSession | undefined;
    set selectedSession(session: ConsoleSession | undefined);
    get(id: string): ConsoleSession | undefined;
    add(session: ConsoleSession): void;
    delete(id: string): void;
}
//# sourceMappingURL=console-session-manager.d.ts.map