/********************************************************************************
 * Copyright (C) 2017 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
import { MenuContribution, MenuModelRegistry } from '../common/menu';
import { KeybindingContribution, KeybindingRegistry } from './keybinding';
import { FrontendApplication, FrontendApplicationContribution } from './frontend-application';
import { CommandContribution, CommandRegistry, Command } from '../common/command';
import { SelectionService } from '../common/selection-service';
import { MessageService } from '../common/message-service';
import { OpenerService } from '../browser/opener-service';
import { ApplicationShell } from './shell/application-shell';
import { AboutDialog } from './about-dialog';
import { ContextKeyService } from './context-key-service';
import { ResourceContextKey } from './resource-context-key';
import { StorageService } from './storage-service';
import { IconThemeService } from './icon-theme-service';
import { ColorContribution } from './color-application-contribution';
import { ColorRegistry } from './color-registry';
import { CoreConfiguration, CorePreferences } from './core-preferences';
import { ThemeService } from './theming';
import { PreferenceService, PreferenceChangeEvent } from './preferences';
import { ClipboardService } from './clipboard-service';
import { EncodingRegistry } from './encoding-registry';
import { EnvVariablesServer } from '../common/env-variables';
import { AuthenticationService } from './authentication-service';
import { QuickInputService } from './quick-input';
import { AsyncLocalizationProvider } from '../common/i18n/localization';
export declare namespace CommonMenus {
    const FILE: string[];
    const FILE_NEW: string[];
    const FILE_OPEN: string[];
    const FILE_SAVE: string[];
    const FILE_AUTOSAVE: string[];
    const FILE_SETTINGS: string[];
    const FILE_SETTINGS_SUBMENU: string[];
    const FILE_SETTINGS_SUBMENU_OPEN: string[];
    const FILE_SETTINGS_SUBMENU_THEME: string[];
    const FILE_CLOSE: string[];
    const EDIT: string[];
    const EDIT_UNDO: string[];
    const EDIT_CLIPBOARD: string[];
    const EDIT_FIND: string[];
    const VIEW: string[];
    const VIEW_PRIMARY: string[];
    const VIEW_VIEWS: string[];
    const VIEW_LAYOUT: string[];
    const VIEW_TOGGLE: string[];
    const SETTINGS_OPEN: string[];
    const SETTINGS__THEME: string[];
    const HELP: string[];
}
export declare namespace CommonCommands {
    const OPEN: Command;
    const CUT: Command;
    const COPY: Command;
    const PASTE: Command;
    const COPY_PATH: Command;
    const UNDO: Command;
    const REDO: Command;
    const SELECT_ALL: Command;
    const FIND: Command;
    const REPLACE: Command;
    const NEXT_TAB: Command;
    const PREVIOUS_TAB: Command;
    const NEXT_TAB_IN_GROUP: Command;
    const PREVIOUS_TAB_IN_GROUP: Command;
    const NEXT_TAB_GROUP: Command;
    const PREVIOUS_TAB_GROUP: Command;
    const CLOSE_TAB: Command;
    const CLOSE_OTHER_TABS: Command;
    const CLOSE_RIGHT_TABS: Command;
    const CLOSE_ALL_TABS: Command;
    const CLOSE_MAIN_TAB: Command;
    const CLOSE_OTHER_MAIN_TABS: Command;
    const CLOSE_ALL_MAIN_TABS: Command;
    const COLLAPSE_PANEL: Command;
    const COLLAPSE_ALL_PANELS: Command;
    const TOGGLE_BOTTOM_PANEL: Command;
    const TOGGLE_STATUS_BAR: Command;
    const TOGGLE_MAXIMIZED: Command;
    const OPEN_VIEW: Command;
    const SAVE: Command;
    const SAVE_WITHOUT_FORMATTING: Command;
    const SAVE_ALL: Command;
    const AUTO_SAVE: Command;
    const ABOUT_COMMAND: Command;
    const OPEN_PREFERENCES: Command;
    const SELECT_COLOR_THEME: Command;
    const SELECT_ICON_THEME: Command;
    const CONFIGURE_DISPLAY_LANGUAGE: Command;
}
export declare const supportCut: boolean;
export declare const supportCopy: boolean;
export declare const supportPaste: boolean;
export declare const RECENT_COMMANDS_STORAGE_KEY = "commands";
export declare class CommonFrontendContribution implements FrontendApplicationContribution, MenuContribution, CommandContribution, KeybindingContribution, ColorContribution {
    protected readonly shell: ApplicationShell;
    protected readonly selectionService: SelectionService;
    protected readonly messageService: MessageService;
    protected readonly openerService: OpenerService;
    protected readonly aboutDialog: AboutDialog;
    protected readonly localizationProvider: AsyncLocalizationProvider;
    constructor(shell: ApplicationShell, selectionService: SelectionService, messageService: MessageService, openerService: OpenerService, aboutDialog: AboutDialog, localizationProvider: AsyncLocalizationProvider);
    protected readonly contextKeyService: ContextKeyService;
    protected readonly resourceContextKey: ResourceContextKey;
    protected readonly commandRegistry: CommandRegistry;
    protected readonly storageService: StorageService;
    protected readonly quickInputService: QuickInputService;
    protected readonly iconThemes: IconThemeService;
    protected readonly themeService: ThemeService;
    protected readonly preferences: CorePreferences;
    protected readonly preferenceService: PreferenceService;
    protected readonly clipboardService: ClipboardService;
    protected readonly encodingRegistry: EncodingRegistry;
    protected readonly environments: EnvVariablesServer;
    protected readonly authenticationService: AuthenticationService;
    configure(app: FrontendApplication): Promise<void>;
    protected updateStyles(): void;
    protected updateThemePreference(preferenceName: 'workbench.colorTheme' | 'workbench.iconTheme'): void;
    protected updateThemeFromPreference(preferenceName: 'workbench.colorTheme' | 'workbench.iconTheme'): void;
    protected handlePreferenceChange(e: PreferenceChangeEvent<CoreConfiguration>, app: FrontendApplication): void;
    onStart(): void;
    onStop(): void;
    protected initResourceContextKeys(): void;
    registerMenus(registry: MenuModelRegistry): void;
    registerCommands(commandRegistry: CommandRegistry): void;
    private findTabArea;
    /**
     * Finds the index of the selected title from the tab-bar.
     * @param tabBar: used for providing an array of titles.
     * @returns the index of the selected title if it is available in the tab-bar, else returns the index of currently-selected title.
     */
    private findTitleIndex;
    private canToggleMaximized;
    /**
     * Maximize the bottom or the main dockpanel based on the widget.
     * @param event used to find the selected widget.
     */
    private toggleMaximized;
    private isElectron;
    registerKeybindings(registry: KeybindingRegistry): void;
    protected openAbout(): Promise<void>;
    protected shouldPreventClose: boolean;
    /**
     * registers event listener which make sure that
     * window doesn't get closed if CMD/CTRL W is pressed.
     * Too many users have that in their muscle memory.
     * Chrome doesn't let us rebind or prevent default the keybinding, so this
     * at least doesn't close the window immediately.
     */
    protected registerCtrlWHandling(): void;
    onWillStop(): true | undefined;
    protected configureDisplayLanguage(): Promise<void>;
    protected selectIconTheme(): void;
    protected selectColorTheme(): void;
    registerColors(colors: ColorRegistry): void;
}
//# sourceMappingURL=common-frontend-contribution.d.ts.map