/********************************************************************************
 * Copyright (C) 2020 Red Hat, Inc. and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
import { CancellationToken, Disposable, Event } from '../common';
import URI from '../common/uri';
export interface DecorationsProvider {
    readonly onDidChange: Event<URI[]>;
    provideDecorations(uri: URI, token: CancellationToken): Decoration | Promise<Decoration | undefined> | undefined;
}
export interface Decoration {
    readonly weight?: number;
    readonly colorId?: string;
    readonly letter?: string;
    readonly tooltip?: string;
    readonly bubble?: boolean;
}
export interface ResourceDecorationChangeEvent {
    affectsResource(uri: URI): boolean;
}
export declare const DecorationsService: unique symbol;
export interface DecorationsService {
    readonly onDidChangeDecorations: Event<Map<string, Decoration>>;
    registerDecorationsProvider(provider: DecorationsProvider): Disposable;
    getDecoration(uri: URI, includeChildren: boolean): Decoration[];
}
export declare class DecorationsServiceImpl implements DecorationsService {
    private readonly data;
    private readonly onDidChangeDecorationsEmitter;
    readonly onDidChangeDecorations: Event<Map<string, Decoration>>;
    dispose(): void;
    registerDecorationsProvider(provider: DecorationsProvider): Disposable;
    getDecoration(uri: URI, includeChildren: boolean): Decoration[];
}
//# sourceMappingURL=decorations-service.d.ts.map